%define _unpackaged_files_terminate_build 1

Name:     netlabel_tools
Version:  0.30.0
Release:  alt3
Summary:  Configuration tools for the Linux NetLabel subsystem
License:  %gpl2only
Group:    System/Base
Url:      https://github.com/netlabel/netlabel_tools

Source:   %name-%version.tar
Patch1:   %name-%version-alt.patch

BuildRequires(pre): rpm-build-licenses
BuildRequires: libnl-devel doxygen systemd-devel

%description
NetLabel is a packet labeling framework that has been present in the upstream
Linux Kernel since 2.6.19. The NetLabel Tools project is a set of userspace
tools and libraries designed to make it easier to use and manage the Linux
Kernel's NetLabel configuration.

%prep
%setup
%patch1 -p1

%build
%autoreconf
%configure --with-systemdsystemunitdir=auto
%make_build

%install
%makeinstall_std

%find_lang --with-man --all-name %name

%files -f %name.lang
%config(noreplace) %_sysconfdir/netlabel.rules
%systemd_unitdir/netlabel.service
%_sbindir/netlabel-config
%_sbindir/netlabelctl
%_man8dir/netlabel-config.8*
%_man8dir/netlabelctl.8*

%changelog
