# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%def_enable GUI
%def_enable OPENMP

Name:     nextpnr
Version:  0.7
Release:  alt1

Summary:  portable FPGA place and route tool
License:  ISC
Group:    Engineering
Url:      https://github.com/YosysHQ/nextpnr

# Source-url: %url/archive/refs/tags/%name-%version.tar.gz
Source: %name-%version.tar

ExcludeArch: %arm

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: python3-devel
BuildRequires: boost-program_options-devel
BuildRequires: boost-filesystem-devel
BuildRequires: eigen3
# gowin
BuildRequires: python3-module-apycula
# # machxo2, ecp5
#BuildRequires: trellis-devel
# check
BuildRequires: ctest

%{?_enable_GUI:BuildRequires: qt5-base-devel}
%{?_enable_OPENMP:BuildRequires: libgomp-devel}

%description
nextpnr aims to be a vendor neutral, timing driven, FOSS FPGA place and
route tool.

%prep
%setup

%build
%cmake \
	-DCURRENT_GIT_VERSION=%version \
	-DARCH=gowin \
	-DGOWIN_BBA_EXECUTABLE=%_bindir/gowin_bba \
	-DBUILD_TESTS=ON \
	-DSTATIC_BUILD=OFF \
	%{?_enable_OPENMP:-DUSE_OPENMP=ON} \
	%{?_enable_GUI:-DBUILD_GUI=ON}

%cmake_build

%install
%cmake_install

%check
%make_build -C %_cmake__builddir test

%files
%_bindir/nextpnr-gowin
%doc *.md docs/*

%changelog
