Name: ngrep
Version: 1.46
Release: alt0.2

Summary: ngrep - network grep
License: BSD-style
Group: Monitoring
Url: http://ngrep.sourceforge.net
# http://git.altlinux.org/gears/n/ngrep.git
Source: %name-%version-%release.tar

Requires: /var/resolv

BuildRequires: libpcap-devel libpcre-devel

Summary(ru_RU.UTF-8): ngrep - поиск строковых масок в сетевом трафике

%description
ngrep strives to provide most of GNU grep's common features, applying them
to the network layer.  ngrep is a pcap-aware tool that will allow you to
specify extended regular expressions to match against data payloads of
packets.  It currently recognizes TCP and UDP across ethernet, ppp and
slip interfaces, and understands bpf filter logic in the same fashion
as more common packet sniffing tools, like tcpdump and snoop.

%description -l ru_RU.UTF-8
ngrep реализует большинство возможностей, предоставляемых утилитой GNU grep
для поиска по образцам, но обрабатывает не файлы, а пакеты сетевого трафика.
Для задания правил поиска можно использовать расширенные регулярные выражения.
Для просмотра сетевого трафика ngrep (так же, как и другие популярные средства
перехвата пакетов наподобие tcpdump и snoop) использует библиотеку pcap.
В настоящий момент поддерживается просмотр пакетов TCP и UDP в Ethernet-,
PPP- и SLIP-соединениях.

%prep
%setup -n %name-%version-%release

%build
%autoreconf
%configure \
	--with-dropprivs-user=%name \
	--with-pcap-includes=%_includedir/pcap \
	--with-regex-impl=sys \
	--enable-ipv6 \
	--enable-pcre \
	--disable-pcap-restart
%make_build STRIPFLAG=

%install
install -pD -m755 %name %buildroot%_sbindir/%name
install -pD -m644 %name.8 %buildroot%_man8dir/%name.8

%pre
%_sbindir/groupadd -r -f %name
%_sbindir/useradd -r -g %name -d /dev/null -s /dev/null -n %name >/dev/null 2>&1 ||:

%files
%_sbindir/%name
%_mandir/man?/*
%doc doc/*.txt usage.html

%changelog
