%define _unpackaged_files_terminate_build 1

Name: nlohmann-json
Version: 3.10.4
Release: alt1

Summary: JSON for Modern C++ (c++11) ("single header file")

License: MIT
Group: Development/C++
Url: https://github.com/nlohmann/json

Packager: Pavel Vainerman <pv@altlinux.ru>

# Source: https://github.com/nlohmann/json/releases/download/v%{version}/json.hpp
Source0: %name-%version.tar
Source1: json_test_data-2.0.0.tar

BuildRequires: cmake ctest gcc-c++

%description
There are myriads of JSON libraries out there, and each may even have its reason to exist. 
Our class had these design goals:
- intuitive syntax.
- Trivial integration.
- Serious testing

%package devel
Summary: JSON for Modern C++ (c++11) ("single header file")
Group: Development/C++
Provides: json-cpp
Obsoletes: json-cpp

%description devel
There are myriads of JSON libraries out there, and each may even have its reason to exist. 
Our class had these design goals:
- intuitive syntax.
- Trivial integration.
- Serious testing

This package contains the single header C++ file and CMake dependency files.

%prep
%setup -a1
rm -rf test/cmake_fetch_content
sed -i -e '/add_subdirectory(cmake_fetch_content)/ d' test/CMakeLists.txt

%build
%cmake \
%ifarch %mips riscv64
    -DJSON_FastTests:BOOL=ON \
%endif
    %nil

%cmake_build

%install
%cmake_install

%check
ln -sf ../json_test_data-2.0.0 %_cmake__builddir/json_test_data
%cmake_build --target test

%files devel
%_includedir/nlohmann
%_libdir/cmake/nlohmann_json
%_pkgconfigdir/nlohmann_json.pc

%changelog
