Name: npm
Version: 8.19.3
Release: alt1

Summary: A package manager for node

Group: Development/Tools
License: MIT
Url: http://nodejs.org/

# Source-url: https://github.com/npm/cli/archive/v%version.tar.gz
Source: %name-%version.tar

Patch1: npm-disable-update-notifier.patch
Patch2: npm-disable-internal-node-gyp.patch
Patch3: npm-fix-user-agent-output.patch

BuildRequires(pre): rpm-macros-nodejs

#BuildRequires: node >= 6.9
#Requires:	node >= 6.9

# Note! Change version with new npm
#Requires: npm(node-gyp) = 5.0.7

BuildArch:	noarch

# we do not need any module provides here
AutoProv: yes,nonodejs
AutoReq: yes,nonodejs

%description
npm is a package manager for node. You can use it to install and publish your
node programs. It manages dependencies and does other cool stuff.

npm is configured to use npm, Inc.'s public package registry
at https://registry.npmjs.org by default.

It is not recommended to build binary libraries within npm module,
but you can install node-gyp package to support that.

In most cases it is enough to install appropriate node- package (like node-sass).

%prep
%setup
%patch1 -p2
%patch2 -p2
%patch3 -p2

# remove all node-gyp deps
rm -rv bin/node-gyp-bin node_modules/node-gyp/

%build
#make man

%install
mkdir -p %buildroot%nodejs_sitelib/%name/ %buildroot%_bindir/
ln -s %nodejs_sitelib/%name/bin/npm-cli.js %buildroot%_bindir/npm
ln -s %nodejs_sitelib/%name/bin/npx-cli.js %buildroot%_bindir/npx

# need inet
#node cli.js install -g --prefix %buildroot%_prefix
# just copy, like in node package was
cp -a . %buildroot%nodejs_sitelib/%name/

# remove all tests from workspaces (ALT bug 42037)
rm -rv %buildroot%nodejs_sitelib/%name/workspaces/*/test/

# remove unused scripts
rm -rv %buildroot%nodejs_sitelib/%name/{scripts,tap-snapshots,test,configure}

# remove all node-gyp deps
rm -rv %buildroot%nodejs_sitelib/%name/node_modules/@npmcli/run-script/lib/node-gyp-bin

# stop symlinks
find %buildroot%nodejs_sitelib/%name/ -type l | while read link ; do
    real=$(realpath $link)
    rm -v $link
    mv -v $real $link
done

%files -n npm
%_bindir/npm
%_bindir/npx
%nodejs_sitelib/%name/

%changelog
