# fix for build on armv7
%remove_optflags -fomit-frame-pointer
%ifnarch %ix86 %arm
%def_with check
%else
%def_without check
%endif

Name: ocaml
Version: 4.13.1
Release: alt1

Summary: The Objective Caml compiler and programming environment
License: LGPLv2.1 with OCaml-LGPL-linking-exception
Group: Development/ML

Url: http://caml.inria.fr/
Source0: %name-%version.tar
Source1: ocaml-reqprov.ml

Patch1: ocaml-3.12.1-alt-stdlib-pdf.patch
Patch2: ocaml-4.13-alt-mk-reqprov.patch
Patch4: ocaml-4.11.1-RH-configure-Allow-user-defined-C-compiler-flags.patch

Requires: rpm-build-ocaml >= 1.4
BuildRequires(pre): rpm-build-ocaml >= 1.1.1

Conflicts: ocaml4
Obsoletes: ocaml4
Provides: ocaml4

# Automatically added by buildreq on Mon Sep 23 2013
BuildRequires: texlive-latex-base texlive-latex-recommended

BuildRequires: binutils-devel

Requires: %name-runtime = %EVR

%package runtime
Summary: Runtime part of the OCaml system
Group: Development/ML
Obsoletes: ocaml4-runtime

%package ocamldoc
Summary: The Objective Caml documentation generator
Group: Development/ML
Requires: %name = %EVR
Provides: ocaml4-ocamldoc
Obsoletes: ocaml4-ocamldoc

%description
Objective Caml is a high-level, strongly-typed, functional and
object-oriented programming language from the ML family of languages.

This package comprises two batch compilers (a fast bytecode compiler and
an optimizing native-code compiler), an interactive toplevel system,
Lex&Yacc tools, a replay debugger, and a comprehensive library.

%description runtime
Objective Caml is a high-level, strongly-typed, functional and
object-oriented programming language from the ML family of languages.

This package contains the runtime environment needed to run Objective
Caml bytecode.

%description ocamldoc
Objective Caml is a high-level, strongly-typed, functional and
object-oriented programming language from the ML family of languages.

This package provides OCamldoc, a tool that generates documentation
from special comments embedded in source files.

%prep
%setup -T -b 0

%patch1 -p1
%patch2 -p1
%patch4 -p1

%build
%add_optflags -DUSE_NON_CONST -D_FILE_OFFSET_BITS=64
./configure \
	OC_CFLAGS="$CFLAGS" \
	OC_LDFLAGS="$LDFLAGS"  \
	-bindir %_bindir \
	-libdir %_libdir/ocaml \
	-mandir %_mandir \
%if_with check
        --enable-ocamltest \
%endif
	%nil

%make_build world.opt
%make_build opt
%make_build opt.opt

install -pD -m644 %SOURCE1 tools/reqprov.ml
make -C tools reqprov

%install
make install DESTDIR=%buildroot
perl -pi -e "s|%buildroot||" %buildroot%_libdir/ocaml/ld.conf

install -pD -m755 tools/reqprov %buildroot%_rpmlibdir/ocaml-reqprov

%check
pushd testsuite
make -j1 all
popd

%files
%doc Changes LICENSE README.adoc
%_bindir/ocaml*
%exclude %_bindir/ocamlrun
%exclude %_bindir/ocamldoc*
%_man1dir/ocaml*
%exclude %_man1dir/ocamldoc*
%_man3dir/*.3o*
%_libdir/ocaml/camlheader
%_libdir/ocaml/camlheader_ur
%_libdir/ocaml/expunge
%_libdir/ocaml/extract_crc
%_libdir/ocaml/*.*
%exclude %_libdir/ocaml/ld.conf
%_libdir/ocaml/caml/
%exclude %_libdir/ocaml/ocamldoc/
%_libdir/ocaml/threads/
%dir %_libdir/ocaml/compiler-libs
%_libdir/ocaml/compiler-libs/*.mli
%_libdir/ocaml/compiler-libs/*.cmt
%_libdir/ocaml/compiler-libs/*.cmti
%_libdir/ocaml/compiler-libs/*.cmi
%_libdir/ocaml/compiler-libs/*.cmo
%_libdir/ocaml/compiler-libs/*.cma
%_libdir/ocaml/compiler-libs/*.a
%_libdir/ocaml/compiler-libs/*.cmxa
%_libdir/ocaml/compiler-libs/*.cmx
%_libdir/ocaml/compiler-libs/*.o

%files runtime
%_bindir/ocamlrun
%dir %_libdir/ocaml
%config %_libdir/ocaml/ld.conf
%dir %_libdir/ocaml/stublibs
%_libdir/ocaml/stublibs/dllcamlstr.so
%_libdir/ocaml/stublibs/dllthreads.so
%_libdir/ocaml/stublibs/dllunix.so
%_libdir/ocaml/camlheaderd
%_libdir/ocaml/camlheaderi

%dir %_libdir/ocaml/stublibs
%_rpmlibdir/ocaml-reqprov

%files ocamldoc
%_bindir/ocamldoc*
%_man1dir/ocamldoc*
%_libdir/ocaml/ocamldoc/

%changelog
