%set_verify_elf_method textrel=relaxed
%define ocamlmod biniou

Name: ocaml-%ocamlmod
Version: 1.2.1
Release: alt3
Summary: Safe and fast binary data format
Group: Development/ML
License: BSD
Url: http://mjambon.com/biniou.html
# https://github.com/mjambon/biniou
Source0:%name-%version.tar

BuildRequires: ocaml >= 4.08
BuildRequires: ocaml-easy-format-devel
BuildRequires: ocaml-ocamldoc
BuildRequires: dune opam

%description
Biniou (pronounced "be new") is a binary data format designed for
speed, safety, ease of use and backward compatibility as protocols
evolve. Biniou is vastly equivalent to JSON in terms of functionality
but allows implementations several times faster (4 times faster than
yojson), with 25-35%% space savings.

Biniou data can be decoded into human-readable form without knowledge
of type definitions except for field and variant names which are
represented by 31-bit hashes. A program named bdump is provided for
routine visualization of biniou data files.

%package devel
Summary: Development files for %name
Requires: %name = %EVR
Group: Development/ML

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup

%build
%dune_build -p %ocamlmod


%install
%dune_install

%check
%dune_check

# avoid potential future name conflict
mv %buildroot%_bindir/{,ocaml-}bdump

%files -f ocaml-files.runtime
%doc LICENSE

%files devel -f ocaml-files.devel
%doc README.md CHANGES.md
%_bindir/ocaml-bdump

%changelog
