%global pkgname cryptokit
%define ocamlsitelib %_libdir/ocaml
%define pkgsitelib %ocamlsitelib/%pkgname
%define ocamlstublib %_libdir/ocaml/stublibs/

Name: ocaml-%pkgname
Version: 1.16.1
Release: alt2
Group: Development/ML
Summary: OCaml library of cryptographic and hash functions
License: LGPLv2 with OCaml-LGPL-linking-exception
Url: http://forge.ocamlcore.org/projects/cryptokit/
Source0: %name-%version.tar
BuildRequires: ocaml ocaml-ocamldoc ocaml-zarith-devel ocaml-findlib zlib-devel
BuildRequires: dune ocaml-dune-configurator-devel
Provides: ocaml-cryptokit-runtime = %version-%release
Obsoletes: ocaml-cryptokit-runtime

%description
The Cryptokit library for Objective Caml provides a variety of
cryptographic primitives that can be used to implement cryptographic
protocols in security-sensitive applications. The primitives provided
include:

* Symmetric-key cryptography: AES, DES, Triple-DES, ARCfour, in ECB,
  CBC, CFB and OFB modes.
* Public-key cryptography: RSA encryption and signature; Diffie-Hellman
  key agreement.
* Hash functions and MACs: SHA-1, SHA-256, RIPEMD-160, MD5, and MACs
  based on AES and DES.
* Random number generation.
* Encodings and compression: base 64, hexadecimal, Zlib compression.

Additional ciphers and hashes can easily be used in conjunction with
the library. In particular, basic mechanisms such as chaining modes,
output buffering, and padding are provided by generic classes that can
easily be composed with user-provided ciphers. More generally, the
library promotes a "Lego"-like style of constructing and composing
transformations over character streams.

%package devel
Summary: Development files for %name
Requires: %name = %version-%release
Group: Development/ML

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup

%build
%dune_build -p %pkgname @install

%install
%dune_install

%check
%dune_check

%files -f ocaml-files.runtime
%doc LICENSE

%files devel -f ocaml-files.devel
%doc README.md Changes

%changelog
