%define modname csv
Name: ocaml-%modname
Version: 2.4
Release: alt2
Summary: OCaml library for reading and writing CSV files
License: LGPLv2+
Group: Development/ML

Url: https://opam.ocaml.org/packages/csv/

Source: %name-%version.tar
Patch0: %name-%version-%release.patch
BuildRequires: ocaml
BuildRequires: ocaml-uutf-devel
BuildRequires: ocaml-findlib
BuildRequires: dune
BuildRequires(pre): rpm-build-ocaml

%description
This OCaml library can read and write CSV files, including all
extensions used by Excel - eg. quotes, newlines, 8 bit characters in
fields, quote-0 etc.

The library comes with a handy command line tool called csvtool for
handling CSV files from shell scripts.

%package devel
Summary: Development files for %name
Group: Development/ML
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%package -n csvtool
Summary: Command line tool for handling CSV files
Group:Text tools
Conflicts: %name < %EVR

%description -n csvtool
This is a handy command line tool for handling CSV files from shell
scripts based on the library ocaml-csv.

%prep
%setup
%patch0 -p1

%build
%dune_build -p %modname,csvtool

%install
%dune_install %modname csvtool

%files -f ocaml-files.runtime

%files -n csvtool
%doc LICENSE.md
%_bindir/csvtool

%files devel -f ocaml-files.devel
%doc README.md LICENSE.md

%changelog
