%set_verify_elf_method textrel=relaxed
Name: ocaml-mccs
Version: 1.1.13
Release: alt1
Summary: Multi Criteria CUDF Solver with OCaml bindings
# Original C/C++ code is BSD, OCaml bindings are LGPL.
# Linking exception, see included COPYING file.
License: BSD and LGPLv3+ with exceptions
Group: Development/ML
Url: https://github.com/AltGr/ocaml-mccs
Source0: %name-%version.tar
BuildRequires: ocaml
BuildRequires: dune
BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: ocaml-findlib-devel
BuildRequires: ocaml-cudf-devel
BuildRequires: libglpk-devel

%description
mccs (which stands for Multi Criteria CUDF Solver) is a CUDF problem
solver developed at UNS during the European MANCOOSI project.

This project contains a stripped-down version of the mccs solver,
taken from snapshot 1.1, with a binding as an OCaml library, and
building with jbuilder.

The binding enables interoperation with binary CUDF data from the
OCaml CUDF library, and removes the native C++ parsers and printers.

%package devel
Summary: Development files for %name
Group: Development/ML
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup

%build
dune build -p mccs

%install
dune install --destdir=%buildroot 

%files
%doc README.md LICENCE
%dir %_libdir/ocaml/mccs/
%_libdir/ocaml/mccs/META
%_libdir/ocaml/mccs/opam
%_libdir/ocaml/mccs/*.cma
%_libdir/ocaml/mccs/*.cmi
%_libdir/ocaml/mccs/*.cmx
%_libdir/ocaml/mccs/*.cmxs
%_libdir/ocaml/stublibs/*.so
%dir %_libdir/ocaml/mccs/glpk/
%dir %_libdir/ocaml/mccs/glpk/internal/
%_libdir/ocaml/mccs/glpk/internal/*.cma
%_libdir/ocaml/mccs/glpk/internal/*.cmi
%_libdir/ocaml/mccs/glpk/internal/*.cmx
%_libdir/ocaml/mccs/glpk/internal/*.cmxs

%files devel
%_libdir/ocaml/mccs/*.a
%_libdir/ocaml/mccs/*.cmxa
%_libdir/ocaml/mccs/dune-package
%_libdir/ocaml/mccs/*.cmt
%_libdir/ocaml/mccs/*.cmti
%_libdir/ocaml/mccs/*.ml
%_libdir/ocaml/mccs/*.mli
%_libdir/ocaml/mccs/glpk/internal/*.a
%_libdir/ocaml/mccs/glpk/internal/*.cmxa
%_libdir/ocaml/mccs/glpk/internal/*.cmt
%_libdir/ocaml/mccs/glpk/internal/*.ml

%changelog
