%define oname sexplib
Name: ocaml-%oname
Version: 0.14.0
Release: alt3
Summary: OCaml library for converting OCaml values to S-expressions
License: Apache-2.0
Group: Development/ML
Url: https://github.com/janestreet/%oname
Source0: %name-%version.tar
BuildRequires: dune >= 2.0
BuildRequires: ocaml
BuildRequires: ocaml-num
BuildRequires: ocaml-parsexp-devel >= 0.14.0

%description
This library contains functionality for parsing and pretty-printing
S-expressions. In addition to that it contains an extremely useful
preprocessing module for Camlp4, which can be used to automatically
generate code from type definitions for efficiently converting
OCaml-values to S-expressions and vice versa. In combination with the
parsing and pretty-printing functionality this frees users from having
to write their own I/O-routines for datastructures they
define. Possible errors during automatic conversions from
S-expressions to OCaml-values are reported in a very human-readable
way. Another module in the library allows you to extract and replace
sub-expressions in S-expressions.

%package devel
Summary: Development files for %name
Group: Development/ML
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup

%build
%dune_build -p %oname

%check
%dune_check

%install
%dune_install
rm -rf %buildroot%_docdir/%oname

%files -f ocaml-files.runtime
%doc LICENSE.md LICENSE-Tywith.txt
%dir %_libdir/ocaml/sexplib
%dir %_libdir/ocaml/sexplib/num
%dir %_libdir/ocaml/sexplib/unix

%files devel -f ocaml-files.devel
%doc COPYRIGHT.txt README.org CHANGES.md CHANGES.txt

%changelog
