%define pkgname zip
Name: ocaml-%pkgname
Version: 1.11
Release: alt1
Summary: OCaml library for reading and writing zip, jar and gzip files

Group: Development/ML
License: LGPLv2.1+ with OCaml-LGPL-linking-exception
Url: https://github.com/xavierleroy/camlzip

Provides: ocaml4-zip
Obsoletes: ocaml4-zip

Source: %name-%version.tar

BuildRequires: ocaml zlib-devel ocaml-findlib

%description
This Objective Caml library provides easy access to compressed files
in ZIP and GZIP format, as well as to Java JAR files. It provides
functions for reading from and writing to compressed files in these
formats.

%package devel
Summary: Development files for %name
Group: Development/ML
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup

%build
%make_build all
%make_build allopt

cat > META <<EOF
name = "%name"
version = "%version"
requires = "unix"
description = "%description"
archive(byte) = "zip.cma"
archive(native) = "zip.cmxa"
EOF

%install
mkdir -p %buildroot%_libdir/ocaml/%pkgname
mkdir -p %buildroot%_libdir/ocaml/stublibs

export DESTDIR=%buildroot
export OCAMLFIND_DESTDIR=%buildroot%_libdir/ocaml

ocamlfind install %pkgname *.cma *.cmxa *.a *.cmx *.cmi *.mli dll*.so META

%files
%_libdir/ocaml/%pkgname
%_libdir/ocaml/stublibs/*.so
%_libdir/ocaml/stublibs/*.so.owner
%exclude %_libdir/ocaml/%pkgname/*.a
%exclude %_libdir/ocaml/%pkgname/*.cmxa
%exclude %_libdir/ocaml/%pkgname/*.cmx
%exclude %_libdir/ocaml/%pkgname/*.mli

%files devel
%_libdir/ocaml/%pkgname/*.a
%_libdir/ocaml/%pkgname/*.cmxa
%_libdir/ocaml/%pkgname/*.cmx
%_libdir/ocaml/%pkgname/*.mli

%changelog
