Name: opencascade
Version: 7.5.3
Release: alt1
Summary: SDK intended for development of applications dealing with 3D CAD data
License: LGPL-2.1-only-with-OCCT-exception-1.0
Group: Development/Tools
Url: http://www.opencascade.org

# Upstream requires a login to download sources. 
# https://dev.opencascade.org/release
# VCS: https://git.dev.opencascade.org/repos/occt.git
Source: %name-%version.tar
Patch1: opencascade-cmake.patch
Patch2: opencascade-alt-arm-build.patch

Requires: lib%name = %version-%release
Requires: %name-data = %version-%release

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++ libX11-devel libGL-devel libGLU-devel
BuildRequires: tcl-devel tcl-tix libfltk-devel tk-devel libXmu-devel
BuildRequires: java-devel-default libcoin3d-devel libfreetype-devel
BuildRequires: libftgl-devel fontconfig-devel libXi-devel
BuildRequires: libgl2ps-devel zlib-devel libfreeimage-devel
BuildRequires: libXext-devel libvtk-devel doxygen graphviz

%description
Open CASCADE Technology (OCCT) is a suite for 3D surface and solid
modeling, visualization, data exchange and rapid application development. It
is an excellent platform for development of numerical simulation software
including CAD/CAM/CAE, AEC and GIS, as well as PDM applications.

%package -n lib%name
Summary: Shared libraries of Open CASCADE
Group: System/Libraries

%description -n lib%name
Shared libraries of Open CASCADE, development platform for 3D modeling and
numerical simulation applications.

%package devel
Summary: Development files for Open CASCADE Technology
Group: Development/C++
Requires: lib%name = %version-%release
Provides: OCE-devel = %EVR
Obsoletes: OCE-devel < %EVR

%description devel
Development files for Open CASCADE Technology, development platform for 3D
modeling and numerical simulation applications.

%package data
Summary: Data for Open CASCADE
Group: Development/Tools
BuildArch: noarch

%description data
This package contains data and resources for Open CASCADE.

%package samples
Summary: Samples for Open CASCADE
Group: Development/Documentation
BuildArch: noarch

%description samples
This package contains samples for Open CASCADE.

%package doc
Summary: Documentation for Open CASCADE
Group: Development/Documentation
BuildArch: noarch

%description doc
This package contains documentation for Open CASCADE.

%prep
%setup
%patch1 -p1
%ifarch %arm
%patch2 -p2
%endif

%build
# opencascade does some manual install trickery that does not respect DESTDIR.
# Make DESTDIR and environment variable that can be passed into the CMake config.
export DESTDIR="%buildroot"
%cmake_insource -GNinja \
       -DCMAKE_BUILD_TYPE=RelWithDebInfo \
       -DUSE_TBB=False \
       -DUSE_VTK=True \
       -D3RDPARTY_VTK_INCLUDE_DIR=%_includedir/vtk-9.0 \
       -DINSTALL_DIR_LIB=%_lib \
       -DINSTALL_DIR_CMAKE=%_lib/cmake/%name
%ninja_build

%install
%ninja_install
mv %buildroot%_bindir/DRAWEXE-%version %buildroot%_bindir/DRAWEXE

# Install precompiled documentation
cp -a doc/* %buildroot%_datadir/doc/%name/
# Remove installed files with licenses
rm -f /usr/share/doc/opencascade/*

%files
%doc LICENSE_LGPL_21.txt OCCT_LGPL_EXCEPTION.txt README.txt
%_bindir/DRAWEXE

%files -n lib%name
%_libdir/*.so.*

%files devel
%_bindir/*.sh
%_libdir/*.so
%_includedir/*
%_libdir/cmake/%name

%files data
%_datadir/%name
%exclude %_datadir/%name/samples

%files samples
%_datadir/%name/samples

%files doc
%_datadir/doc/%name

%changelog
