%define _unpackaged_files_terminate_build 1
%define _sover 2.4
%define _bname openldap
### Build switches for enable or disable fiture ###
%def_enable doc
%def_enable sql
%def_enable perl
%def_disable shell
%def_enable sasl
### Disable, because while build by rpm is not passed
%def_disable debug
%def_disable slapi
%def_enable slp
%def_enable overlay
%def_enable aci
%def_enable yielding
%def_enable ntlm
%define contrib_slapo_name acl addpartial allop allowed autogroup cloak denyop dsaschema dupent kinit lastbind lastmod noopsrch nops passwd/sha2 passwd/pbkdf2 samba4 trace

Name: openldap
Version: %_sover.59
Release: alt1.p10.3

Provides: openldap2.4 = %version-%release
Obsoletes: openldap2.4 < %version-%release

%define so_maj %_sover
%define ldap_ssl_dir %_sysconfdir/%name/ssl
%define ssl_dir %_localstatedir/ssl/certs
%define ldap_dir %_localstatedir/ldap

Summary: LDAP libraries and sample clients
License: OLDAP-2.8
Group: System/Servers
Url: http://www.openldap.org/

Packager: OpenLDAP Maintainers Team <openldap@packages.altlinux.org>

# ftp://ftp.openldap.org/pub/OpenLDAP/openldap-release/
Source: %name-%version.tar

# Docs for this products
#Source2: %name-README.upgrading
Source3: %_bname-README.ALT
Source4: %_bname-config-README.ALT

# System Specific source
Source11: %_bname.sysconfig
Source12: %_bname-slapd.init
Source13: %_bname.logrotate
Source14: %_bname-slapd.service

## Chroot config
Source15: %_bname-ldap.all
Source16: %_bname-ldap.conf
Source17: %_bname-ldap.lib
# This file we need to build from original dynamic
Source18: %_bname-slapd.conf
Source19: %_bname-bdb-DB_CONFIG
Source20: %_bname-slapd-access.conf
Source21: %_bname-slapd-mdb-db01.conf
Source22: %_bname-slapd-hdb-db01.conf
Source23: %_bname-slapd-hdb-db02.conf
# OLC config directory backup/restore scripts
Source40: %_bname-olc-backup
Source41: %_bname-olc-restore

# Extended OpenLDAP schemas
Source50: %_bname-addon-schemas.tar
Source51: %_bname-ALT-rootdse.ldif

### PATCHES
Patch1: %_bname-alt-defaults.patch

## Patch created by Alexander Bokovoy <ab@altlinux.ru>
Patch2: %_bname-2.3.34-alt-pid.patch
Patch3: %_bname-2.3.12-autoconf-2.5-alt.patch

Patch4: %_bname-2.3.20-alt-makefile.patch

Patch7: %_bname-2.3.34-alt-meta-backend.patch

Patch8: %_bname-2.3.37-alt-ntlm.patch

Patch11: %_bname-2.3.43-fix-ucred.patch

Patch13: %_bname-2.4.25-rh-ldaprc-currentdir.patch
Patch14: %_bname-2.4.25-rh-reentrant-gethostby.patch
Patch18: %_bname-2.4.31-rh-nss-allow-ca-dbdir-pemfile.patch
Patch19: %_bname-2.4.31-rh-tls-unbind-shutdown-order.patch
Patch20: %_bname-2.4.31-rh-nss-dont-overwrite-verify-cert-error.patch
Patch21: %_bname-2.4.31-rh-nss-clean-memory-for-token-pin.patch
Patch22: %_bname-2.4.31-rh-cve-nss-cipher-suite-ignored.patch
Patch23: %_bname-2.4.31-rh-nss-default-cipher-suite-always-selected.patch
Patch24: %_bname-2.4.31-rh-nss-multiple-tls-contexts.patch
Patch25: openldap-2.4.32-alt-gcc5.1.patch
Patch27: openldap-2.4.42-CVE-2015-3276.patch
Patch28: openldap-cbinding-ITS-9215-fix-for-glibc-again.patch
Patch29: openldap-2.4.59-CVE-2022-29155.patch
Patch30: openldap-2.4.59-CVE-2023-2953.patch

### REQUIRE Section

%if_enabled doc
# For compile documentations need "sdf".
BuildRequires: sdf >= 2
%endif
%if_enabled sasl
# due to SASL_AUXPROP_PLUG_VERSION
BuildRequires: libsasl2-devel >= 2.1.24-alt1.cvs.20090508
%endif
%if_enabled sql
BuildRequires: libunixODBC-devel
%endif
%if_enabled perl
BuildRequires: perl-devel
%endif
%if_enabled slp
BuildRequires: libopenslp-devel
%endif

# Automatically added by buildreq on Tue Oct 18 2011 (-bi)
BuildRequires: chrooted groff-base libdb4.8-devel libltdl-devel libssl-devel shtool
# For contrib
BuildRequires: libkrb5-devel

%package -n libldap
Summary: OpenLDAP libraries
Group: System/Libraries
Provides: libldap2.4 = %version-%release
Obsoletes: libldap2.4 < %version-%release
Requires: %name-common = %version-%release

%package -n libldap-devel
Summary: OpenLDAP development libraries and header files
Group: Development/C
Requires: libldap = %version-%release

Provides: openldap-devel = %version-%release
Obsoletes: openldap-devel < %version-%release

%package -n libldap-devel-static
Summary: OpenLDAP development static libraries
Group: Development/C
Requires: libldap-devel = %version-%release
Provides: openldap-devel-static = %version-%release
Obsoletes: openldap-devel-static < %version-%release

%package common
Summary: Common files for OpenLDAP
Group: System/Servers
Obsoletes: %name < 2.4.56-alt1
BuildArch: noarch

%package servers
Summary: LDAP servers
Group: System/Servers
Requires: libldap = %version-%release

Provides: openldap2.4-servers = %version-%release
Obsoletes: openldap2.4-servers < %version-%release

%package clients
Summary: LDAP utilities, tools and sample clients
Group: Networking/Remote access
Requires: libldap = %version-%release

Provides: openldap2.4-clients = %version-%release
Obsoletes: openldap2.4-clients < %version-%release

%if_enabled doc
%package -n %_bname-doc
Summary: OpenLDAP administration guide
Group: Books/Computer books
BuildArch: noarch

Provides: openldap2.4-doc = %version-%release
Obsoletes: openldap2.4-doc < %version-%release
%endif

%description
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

Install %_bname if you need to run LDAP-based applications and tools.

%description -n libldap
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

This package contains shared libraries needed for make works %_bname-based softare.

%description -n libldap-devel
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

This package includes the development libraries and header files needed
for developing applications that use LDAP internals. Install this package
only if you plan to develop or will need to compile customized LDAP clients.

%description -n libldap-devel-static
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

This package includes the static libraries needed for developing statically
linked applications that use LDAP internals.

%description common
Common files for OpenLDAP.

%description servers
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

Install %_bname-servers if you need LDAP servers.

%description clients
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

Install %_bname-client if you need LDAP applications and tools.

%if_enabled doc
%description -n %_bname-doc
OpenLDAP Administration Guide
HTML and TXT versions
%endif

%package contrib
Summary: OpenLDAP Contrib Modules
Group: System/Servers
Requires: %name-servers = %version-%release

%description contrib
Various overlays found in contrib directory.

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
#%%patch7 -p1

%if_enabled ntlm
%patch8 -p1 -b .ntlm
%endif

%patch11 -p1

%patch13 -p1
%patch14 -p1

%patch27 -p1
%patch28 -p1
%patch29 -p1
%patch30 -p2

# Add some more schema for the sake of migration scripts and others
pushd servers/slapd
tar -xf %SOURCE50
popd


%build
# Options -lresolv in line below need for some bad configure scripts like in auth_ldap package
#export LDFLAGS="$LDFLAGS -lresolv"
export CPPFLAGS="$CPPFLAGS -DLOG_DAEMON=1"

# enable experimental support for LDAP over UDP (LDAP_CONNECTIONLESS)
export CFLAGS="${CFLAGS} ${LDFLAGS} -Wl,--as-needed -DLDAP_CONNECTIONLESS -DLDAP_USE_NON_BLOCKING_TLS -DOPENSSL_NO_MD2"

shtoolize all
aclocal
autoconf
libtoolize --force --install

%configure \
	--enable-syslog \
	--enable-proctitle \
	--enable-dynamic \
	--with-tls=openssl \
	--with-threads \
	--enable-slapd \
	--enable-lmpasswd \
	--enable-crypt \
	--enable-cleartext \
	--enable-modules \
	--enable-rewrite \
	--enable-bdb=mod \
	--enable-hdb=mod \
	--enable-dnssrv=mod \
	--enable-ldap=mod \
	--enable-relay=mod \
	--enable-memberof=mod \
	--enable-meta=mod \
	--enable-monitor=mod \
	--enable-null=mod \
	--enable-passwd=mod \
	\
%if_enabled yielding
	--with-yielding-select \
%else
	--without-yielding-select \
%endif
%if_enabled aci
	--enable-aci \
%else
	--disable-aci \
%endif
%if_enabled slapi
	--enable-slapi \
%else
	--disable-slapi \
%endif
%if_enabled slp
	--enable-slp \
%else
	--disable-slp \
%endif
%if_enabled shell
	--enable-shell=mod \
	--without-threads \
%else
	--disable-shell \
	--with-threads \
%endif
%if_enabled sql
	--enable-sql=mod \
%else
	--disable-sql \
%endif
%if_enabled sasl
	--with-cyrus-sasl \
	--enable-spasswd \
%else
	--without-cyrus-sasl \
%endif
%if_enabled perl
	--enable-perl=mod \
%else
	--disable-perl \
%endif
%if_enabled overlay
    --enable-overlays=mod \
%else
	--disable-overlays=mod \
%endif
%if_enabled debug
	--enable-debug \
%endif


%__subst 's/^AC_CFLAGS.*/& %optflags_shared/' libraries/librewrite/Makefile

%make depend
export NPROCS=1
%make_build

pushd libraries/liblutil
rm -f libldif.la
MOD_LIBS="-L../liblber/.libs/ -L../libldap/.libs/ -llber -lldap" make
popd

# Build selected contrib overlays
for SLAPO_NAME in %contrib_slapo_name
do
  %make_build -C contrib/slapd-modules/${SLAPO_NAME} prefix="%_prefix" libdir="%_libdir" libexecdir="%_libexecdir" 
done
# slapo-smbk5pwd only for Samba password hashes
%make_build -C contrib/slapd-modules/smbk5pwd DEFS="-DDO_SAMBA" HEIMDAL_LIB="" prefix="%_prefix" libdir="%_libdir" libexecdir="%_libexecdir"

%if_enabled doc
# Build Administrator Guide in html and text mode
pushd doc/guide/admin
sdf -2topics index.sdf
sdf -2txt guide.sdf
popd
%endif

%install
%makeinstall_std STRIP=""
###
## Install all slapd's file
###

# Install selected contrib overlays
for SLAPO_NAME in %contrib_slapo_name smbk5pwd
do
  %make_install -C contrib/slapd-modules/${SLAPO_NAME} STRIP="" DESTDIR="%buildroot" prefix="%_prefix" libdir="%_libdir" libexecdir="%_libexecdir" install
done

# Create the /var/lib data directory and chroot enviroment.
mkdir -p -m750 %buildroot%ldap_dir
#__mkdir_p -m750 %buildroot%ldap_dir/bases
mkdir -p -m770 %buildroot%ldap_dir/dblogs
#__mkdir_p -m750 %buildroot%ldap_dir/replica
mkdir -p -m755 %buildroot%ldap_dir/dev
mkdir -p -m750 %buildroot%ldap_dir/%_sysconfdir/ssl
mkdir -p -m750 %buildroot%ldap_dir/%_sysconfdir/schema
ln -s . %buildroot%ldap_dir/%_sysconfdir/%_bname
mkdir -p -m775 %buildroot%ldap_dir/lib
ln -s lib %buildroot%ldap_dir/lib64
mkdir -p -m755 %buildroot%ldap_dir/usr/lib/%_bname
mkdir -p -m755 %buildroot%ldap_dir/usr/lib/sasl2-3
ln -s lib %buildroot%ldap_dir/usr/lib64
mkdir -p -m775 %buildroot%ldap_dir/var/run
mkdir -p -m775 %buildroot%ldap_dir%ldap_dir
ln -s ../../../bases %buildroot%ldap_dir%ldap_dir/
ln -s ../../../dblogs %buildroot%ldap_dir%ldap_dir/
mksock %buildroot%ldap_dir/dev/log

# Install init scripts.
install -pD -m644 %SOURCE11 %buildroot/%_sysconfdir/sysconfig/ldap
install -pD -m755 %SOURCE12 %buildroot/%_initdir/slapd
mkdir -p -m750 %buildroot/%_sysconfdir/chroot.d
install -pD -m750 %SOURCE15 %buildroot/%_sysconfdir/chroot.d/ldap.all
install -pD -m750 %SOURCE16 %buildroot/%_sysconfdir/chroot.d/ldap.conf
install -pD -m750 %SOURCE17 %buildroot/%_sysconfdir/chroot.d/ldap.lib
install -pD -m644 %SOURCE14 %buildroot/%systemd_unitdir/slapd.service

# Install OLC (cn=config) directory backup/restore scripts
install -pD -m750 %SOURCE40 %buildroot%_sbindir/slapd-olc-backup
install -pD -m750 %SOURCE41 %buildroot%_sbindir/slapd-olc-restore

# log repository and logrotate config
#__mkdir_p -m750 %buildroot/%_logdir/ldap
#__install -pD -m644 %SOURCE13 %buildroot/%_sysconfdir/logrotate.d/ldap

# syslog.d
mkdir -pm700 %buildroot%_sysconfdir/syslog.d
ln -s %ldap_dir/dev/log %buildroot%_sysconfdir/syslog.d/ldap

# config files
mkdir -p -m750 %buildroot/%_sysconfdir/%_bname/ssl
install -pD -m640 %SOURCE18 %buildroot/%_sysconfdir/%_bname/slapd.conf
install -pD -m640 %SOURCE19 %buildroot%ldap_dir/bases/DB_CONFIG
install -pD -m640 %SOURCE20 %buildroot/%_sysconfdir/%_bname/slapd-access.conf
install -pD -m640 %SOURCE21 %buildroot/%_sysconfdir/%_bname/slapd-mdb-db01.conf
install -pD -m640 %SOURCE22 %buildroot/%_sysconfdir/%_bname/slapd-hdb-db01.conf
install -pD -m640 %SOURCE23 %buildroot/%_sysconfdir/%_bname/slapd-hdb-db02.conf
install -pD -m644 %SOURCE51 %buildroot/%_sysconfdir/%_bname/rootdse.ldif

# We don't need the default files - let's move it.
mkdir -p %buildroot/%_docdir/%_bname-servers-%version/default
mv %buildroot/%_sysconfdir/%_bname/*.default \
	%buildroot/%_docdir/%_bname-servers-%version/default/
mv %buildroot/%_sysconfdir/%_bname/*.example \
	%buildroot/%_docdir/%_bname-servers-%version/
rm -f %buildroot%ldap_dir/bases/*.example
rm -f %buildroot%_sysconfdir/%_bname/slapd.ldif

# Documentations for servers
mkdir -p %buildroot/%_docdir/%_bname-servers-%version/{back-{null,perl,sql},schema,slapi,overlays}/
install -D -m644 servers/slapd/back-ldap/TODO.proxy \
	%buildroot/%_docdir/%_bname-servers-%version/back-ldap/TODO.proxy
install -D -m644 servers/slapd/back-monitor/README \
	%buildroot/%_docdir/%_bname-servers-%version/back-monitor/README
install -D -m644 servers/slapd/back-null/README \
	%buildroot/%_docdir/%_bname-servers-%version/back-null/README
%if_enabled perl
install -D -m644 servers/slapd/back-perl/{README,SampleLDAP.pm} \
	%buildroot/%_docdir/%_bname-servers-%version/back-perl/
%endif
%if_enabled shell
install -D -m644 servers/slapd/back-shell/searchexample.{conf,sh} \
	%buildroot/%_docdir/%_bname-servers-%version/back-shell/
%endif

%if_enabled sql
install -D -m644 servers/slapd/back-sql/docs/* \
	%buildroot/%_docdir/%_bname-servers-%version/back-sql/
cp -r servers/slapd/back-sql/rdbms_depend \
	%buildroot/%_docdir/%_bname-servers-%version/back-sql/
%endif

%if_enabled slapi
install -pD -m644 servers/slapd/slapi/TODO \
        %buildroot/%_docdir/%_bname-servers-%version/slapi/TODO
%endif

%if_enabled overlay
install -pD -m644 servers/slapd/overlays/README \
        %buildroot/%_docdir/%_bname-servers-%version/overlays/README
install -pD -m644 servers/slapd/overlays/slapover.txt \
        %buildroot/%_docdir/%_bname-servers-%version/overlays/slapover.txt
install -pD -m644 contrib/slapd-modules/smbk5pwd/README \
        %buildroot/%_docdir/%_bname-servers-%version/overlays/README.smbk5pwd
install -pD -m644 contrib/slapd-modules/allop/README \
        %buildroot/%_docdir/%_bname-servers-%version/overlays/README.allop
%endif

install -p -m644 servers/slapd/schema/README \
	%buildroot/%_docdir/%_bname-servers-%version/schema/README
##slapd
install -p -m644 %SOURCE3 \
	%buildroot/%_docdir/%_bname-servers-%version/README.ALT
install -p -m644 %SOURCE4 \
	%buildroot/%_docdir/%_bname-servers-%version/config-README.ALT

%if_enabled doc
## Install Administration Guide 
mkdir -p %buildroot/%_docdir/%_bname-doc-%version/images
install -pD -m644 doc/guide/images/*.gif \
	%buildroot/%_docdir/%_bname-doc-%version/images
mkdir -p %buildroot/%_docdir/%_bname-doc-%version/admin-guide
#install -pD -m644 doc/guide/admin/*.gif \
#	%buildroot/%_docdir/%_bname-doc-%version/admin-guide/
install -pD -m644 doc/guide/admin/*.html \
	%buildroot/%_docdir/%_bname-doc-%version/admin-guide/
install -p -m644 doc/guide/admin/guide.txt \
	%buildroot/%_docdir/%_bname-doc-%version/
%endif

# Purge dependency_libs from .la files.
%__subst -p 's/^\(dependency_libs=\).*/\1'\'\'/ \
	%buildroot/%_libexecdir/%_bname/*.la

#======
# Relocate some shared libraries from %_libdir/ to /%_lib/.
mkdir -p %buildroot/%_lib
for n in ldap lber; do
	for f in %buildroot/%_libdir/lib$n.so; do
		t=`objdump -p "$f" |awk '/SONAME/ {print $2}'`
		[ -n "$t" ]
		ln -s -nf ../../%_lib/"$t" "$f"
	done
    mv %buildroot/%_libdir/lib$n-*.so.* %buildroot/%_lib/
done

# Remove static libraries for contrib
rm -f %buildroot%_libexecdir/%_bname/*.a

%check
%make_build test

%pre servers
# Take care to only do ownership-changing if we're adding the user.
/usr/sbin/groupadd -rf ldap
/usr/sbin/useradd  -rM -c "LDAP User" -g ldap -u 55 -s /dev/null -d %ldap_dir ldap &>/dev/null
if [ -d "$ldap_ssl_dir" -a ! -L "$ldap_ssl_dir" ]; then
	echo "Your certificates are moved to $ldap_ssl_dir.rpmsave, please CHECK!"
	mv "$ldap_ssl_dir" "$ldap_ssl_dir".rpmsave
fi	

%post servers
# remove old libs from chroot
rm -f /var/lib/ldap/%_libdir/openldap/*
rm -f /var/lib/ldap/%_libdir/sasl2-3/*
rm -f /var/lib/ldap/%_libdir/*.so*
rm -f /var/lib/ldap/%_lib/*.so*

%post_service slapd


%preun servers
%preun_service slapd


%files -n libldap
/%_lib/*.so.*
%_libdir/*.so.*

%files -n libldap-devel
%_libdir/*.so
%_includedir/*
%_man3dir/*
%doc doc/{drafts,rfc,devel}

%files -n libldap-devel-static
%_libdir/*.a

%files common
%doc ANNOUNCEMENT CHANGES COPYRIGHT LICENSE README
%dir %_sysconfdir/%_bname
%config(noreplace) %_sysconfdir/%_bname/ldap.conf
# libldap/client config
%_man5dir/ldap.conf.*
# the common format
%_man5dir/ldif.*

%files servers
%_sysconfdir/chroot.d/ldap.all
%_sysconfdir/chroot.d/ldap.conf
%_sysconfdir/chroot.d/ldap.lib
%_sysconfdir/syslog.d/ldap
#config(noreplace) %_sysconfdir/logrotate.d/ldap

%dir %_sysconfdir/%_bname/schema
%_sysconfdir/%_bname/schema
%attr(750,root,ldap) %dir %_sysconfdir/%_bname/ssl

%config(noreplace) %_sysconfdir/%_bname/rootdse.ldif
%attr(-,root,ldap)%config(noreplace) %_sysconfdir/%_bname/slapd-access.conf
%attr(-,root,ldap)%config(noreplace) %_sysconfdir/%_bname/slapd-mdb-db01.conf
%attr(-,root,ldap)%config(noreplace) %_sysconfdir/%_bname/slapd-hdb-db01.conf
%attr(-,root,ldap)%config(noreplace) %_sysconfdir/%_bname/slapd-hdb-db02.conf
%attr(-,root,ldap)%config(noreplace) %_sysconfdir/%_bname/slapd.conf

%_initdir/slapd
%systemd_unitdir/slapd.service
%config(noreplace) %_sysconfdir/sysconfig/ldap

%_sbindir/slapacl
%_sbindir/slapadd
%_sbindir/slapauth
%_sbindir/slapcat
%_sbindir/slapd
%_sbindir/slapdn
%_sbindir/slapindex
%_sbindir/slappasswd
%_sbindir/slaptest
%_sbindir/slapschema
%_sbindir/slapd-olc-backup
%_sbindir/slapd-olc-restore

%dir %_libexecdir/%name
%_libexecdir/%name/accesslog*
%_libexecdir/%name/auditlog*
%_libexecdir/%name/back_bdb*
%_libexecdir/%name/back_dnssrv*
%_libexecdir/%name/back_hdb*
%_libexecdir/%name/back_ldap*
%_libexecdir/%name/back_meta*
%_libexecdir/%name/back_monitor*
%_libexecdir/%name/back_null*
%_libexecdir/%name/back_passwd*
%_libexecdir/%name/back_perl*
%_libexecdir/%name/back_relay*
%_libexecdir/%name/back_sql*
%_libexecdir/%name/collect*
%_libexecdir/%name/constraint*
%_libexecdir/%name/dds*
%_libexecdir/%name/deref*
%_libexecdir/%name/dyngroup*
%_libexecdir/%name/dynlist*
%_libexecdir/%name/memberof*
%_libexecdir/%name/pcache*
%_libexecdir/%name/ppolicy*
%_libexecdir/%name/refint*
%_libexecdir/%name/retcode*
%_libexecdir/%name/rwm*
%_libexecdir/%name/seqmod*
%_libexecdir/%name/sssvlv*
%_libexecdir/%name/syncprov*
%_libexecdir/%name/translucent*
%_libexecdir/%name/unique*
%_libexecdir/%name/valsort*

%_man5dir/*
%_man8dir/*
# Not server-related file formats:
# libldap/client config
%exclude %_man5dir/ldap.conf.*
# the common format
%exclude %_man5dir/ldif.*

%doc %_docdir/%_bname-servers-%version
#attr(0775,root,ldap) %dir %_logdir/ldap

%attr(0750,root,ldap) %dir %ldap_dir
%attr(1770,root,ldap) %dir %ldap_dir/bases
%attr(0640,root,ldap) %ldap_dir/bases/DB_CONFIG
%attr(1770,root,ldap) %ldap_dir/dblogs
%attr(0775,root,ldap) %ldap_dir/dev
%attr(0755,root,ldap) %ldap_dir/etc
%attr(0750,root,ldap) %ldap_dir/lib
%ldap_dir/lib64
%ldap_dir/usr
%ldap_dir/var
%attr(0775,root,ldap) %dir %ldap_dir/var/run

##### CLIENTS
%files clients
%_bindir/ldapadd
%_bindir/ldapcompare
%_bindir/ldapdelete
%_bindir/ldapmodify
%_bindir/ldapmodrdn
%_bindir/ldappasswd
%_bindir/ldapsearch
%_bindir/ldapwhoami
%_bindir/ldapexop
%_bindir/ldapurl
%_man1dir/*

%if_enabled doc
##### GUIDE
%files -n %_bname-doc
%_docdir/%_bname-doc-%version/*
%dir %_docdir/%_bname-doc-%version/
%endif

##### CONTRIB modules
%files contrib
%_libexecdir/%name/addpartial*
%_libexecdir/%name/allop*
%_libexecdir/%name/allowed*
%_libexecdir/%name/autogroup*
%_libexecdir/%name/cloak*
%_libexecdir/%name/denyop*
%_libexecdir/%name/dsaschema*
%_libexecdir/%name/dupent*
%_libexecdir/%name/gssacl*
%_libexecdir/%name/kinit*
%_libexecdir/%name/lastbind*
%_libexecdir/%name/lastmod*
%_libexecdir/%name/noopsrch*
%_libexecdir/%name/nops*
%_libexecdir/%name/pguid*
%_libexecdir/%name/posixgroup*
%_libexecdir/%name/pw-pbkdf2*
%_libexecdir/%name/pw-sha2*
%_libexecdir/%name/rdnval*
%_libexecdir/%name/smbk5pwd*
%_libexecdir/%name/trace*
%_libexecdir/%name/vernum*

###
# TODO for 2.2.x
#
#[global] correct install all docs to %_docdir
#[global] Correct build with SASL(+++) Need tests
#[FR] Translate Admin Guide
#[FR] Translate LDAP Tools and add working in LOCALE Run-Time envirement.
#[FR] Make load modules correctly by dlopen without *.la files
#[global] Copy or not in back-meta/data directory (may be need to copy this data to Docs dir).
#[NeedBugFix] Remove TEXTREL from back-{modules}
#[global] What is back-tcl ?? man is here, but back modules isn't.
#[global] Generate slapd.conf according slapd.conf in source and man pages back-*
#[global] Create new config shema
#[FR] Import, may be, backup shema from MDK
#[global] Work on SSL/TLS cert dir!(+++) Need tests. 
#[FR] Correct patch for aacls for latest version
#[FR] Create separate package with OpenLDAP test for ALT Specific chroot env
#[FR] Create chroot-scripts dynamic while build package 

%changelog
