%def_disable snapshot
%ifarch %e2k ppc64le
%def_disable qtwebengine
%else
%def_enable qtwebengine
%endif
%define ver_major 2.5
%define xdg_name org.openshot.OpenShot


Name: openshot
Version: %ver_major.2
Release: alt2.1

Summary: Non Linear Video Editor using Python and MLT
Group: Video
License: GPL-3.0
Url: http://www.openshotvideo.com/

%if_disabled snapshot
#Source: https://launchpad.net/%name/%ver_major/%version/+download/%name-qt-%version.tar.gz
Source: https://github.com/OpenShot/openshot-qt/archive/v%version/%name-qt-%version.tar.gz
%else
Vcs: https://github.com/OpenShot/openshot-qt.git
Source: %name-%version.tar.gz
%endif

# blender > 2.80 doesn't support 32-bit
ExcludeArch: i586 armh

Requires: python3-module-%name >= 0.2.5
Requires: blender inkscape xdg-utils

%add_typelib_req_skiplist typelib(Unity)
# should be self-satisfied
%add_python3_req_skip classes classes.legacy.openshot.classes images
# should be provided by blender
%add_python3_req_skip bpy.props
%if_enabled qtwebengine
%add_python3_req_skip PyQt5.QtWebKit PyQt5.QtWebKitWidgets
%else
%add_python3_req_skip PyQt5.QtWebEngineCore PyQt5.QtWebEngineWidgets
%endif

%define __python %nil
BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: python3-devel python3-module-setuptools python3-module-PyQt5

%description
OpenShot Video Editor is a free, open-source, non-linear video editor. It
can create and edit videos and movies using many popular video, audio,
and image formats. Create videos for YouTube, Flickr, Vimeo, Metacafe,
Xbox, and many more common formats.

%prep
%setup -n %name-qt-%version

%build
%python3_build

%install
%python3_install --install-lib=%python3_sitelibdir

#%find_lang --with-qt %name OpenShot
#-f OpenShot.lang

%files
%_bindir/*
%python3_sitelibdir/%{name}_qt/
%python3_sitelibdir/*.egg-info/
%_pixmapsdir/*
%_desktopdir/*
%_iconsdir/hicolor/*/*/%{name}-qt*
%_datadir/mime/packages/*
%_datadir/metainfo/%xdg_name.appdata.xml
%doc AUTHORS README*


%changelog
