%def_enable tsget
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

Name: openssl1.1
Version: 1.1.1w
Release: alt0.p10.2

Summary: OpenSSL - Secure Sockets Layer and cryptography shared libraries and tools
License: OpenSSL
Group: System/Base
Url: http://www.openssl.org

# Repacked https://openssl.org/source/openssl-%version.tar.gz
Source: openssl-%version.tar

Source1: openssl-config
Source2: Makefile.certificate
Source3: make-dummy-cert
Source4: cc.sh

# Backported fixes including security fixes
Patch500: openssl-CVE-2023-5678.patch
Patch501: openssl-CVE-2024-0727.patch
Patch502: openssl-CVE-2024-2511.patch
Patch503: openssl-CVE-2024-4741.patch
Patch504: openssl-CVE-2024-5535.patch
Patch505: openssl-CVE-2024-9143.patch

Patch01: openssl-upstream-branch-updates.patch
Patch03: openssl-alt-config.patch
Patch04: openssl-alt-engines-path.patch
Patch05: openssl-alt-e2k-makecontext.patch

# Patches from Fedora
# Build changes
Patch101: openssl-rh-build.patch
# Patch102: openssl-rh-defaults.patch (different config)
Patch103: openssl-rh-no-html.patch
# Patch104: openssl-rh-man-rename.patch (not needed)
# Bug fixes
Patch121: openssl-rh-issuer-hash.patch
# Functionality changes
# Patch131: openssl-rh-conf-paths.patch (changes config)
Patch132: openssl-rh-version-add-engines.patch
Patch133: openssl-rh-apps-dgst.patch
# Patch136: openssl-rh-no-brainpool.patch (why disable it?)
# Patch137: openssl-rh-ec-curves.patch (breaks tests; we have no reason to disable this curves, right?)
Patch138: openssl-rh-no-weak-verify.patch
Patch140: openssl-rh-disable-ssl3.patch
Patch141: openssl-rh-system-cipherlist.patch
# Patch142: openssl-rh-fips.patch (not needed)
# Patch143: openssl-rh-ignore-bound.patch (not sure)
# Patch144: openssl-rh-version-override.patch (not needed; FIPS)
Patch145: openssl-rh-weak-ciphers.patch
# Patch146: openssl-rh-seclevel.patch (not needed; FIPS)
# Patch148: openssl-rh-fips-post-rand.patch (not needed)
# Patch149: openssl-rh-evp-kdf.patch (new functionality; not sure)
# Patch150: openssl-rh-ssh-kdf.patch (new functionality; not sure)

%define shlib_soversion 1.1
%define openssldir /var/lib/ssl
%define old_openssldir %_libdir/ssl

BuildRequires: /usr/bin/pod2man bc zlib-devel perl-PathTools
%if_enabled tsget
BuildRequires: perl-WWW-Curl
%endif

%{?!_without_check:%{?!_disable_check:BuildRequires: perl-Module-Load-Conditional perl-devel perl-Math-BigInt}}

%package -n libcrypto%shlib_soversion
Summary: OpenSSL libcrypto shared library
Group: System/Libraries
Provides: libcrypto = %version-%release
# due to openssl.cnf
Conflicts: libcrypto7, libssl7, libssl6 < 0.9.8d-alt6, libcrypto10 <= 1.0.2q-alt1
# due to openssldir migration
Conflicts: openssl < 0:0.9.8d-alt1
# due to runtime openssl version check
Conflicts: openssh-common < 5.9p1-alt5
Requires: ca-certificates

%package -n libssl%shlib_soversion
Summary: OpenSSL libssl shared library
Group: System/Libraries
Provides: libssl = %version
Requires: libcrypto%shlib_soversion = %version-%release

%package -n libssl-devel
Summary: OpenSSL include files and development libraries
Group: Development/C
Provides: openssl-devel = %version
Obsoletes: openssl-devel < %version
Requires: libssl%shlib_soversion = %version-%release
# due to /usr/bin/openssl-config
Conflicts: openssl < %version-%release, openssl > %version-%release
# manpage clash: crypto(3).
Conflicts: erlang <= 0:R9C.0-alt2

%package -n libssl-devel-static
Summary: OpenSSL static libraries
Group: Development/C
Provides: openssl-devel-static = %version
Obsoletes: openssl-devel-static < %version
Requires: libssl-devel = %version-%release

%package -n openssl
Summary: OpenSSL tools
Group: System/Base
Provides: %openssldir
# due to /usr/bin/openssl-config
Conflicts: libssl-devel < %version-%release, libssl-devel > %version-%release
Requires: libssl%shlib_soversion = %version-%release

%package -n openssl-doc
Summary: OpenSSL documentation and demos
Group: Development/C
Requires: openssl = %version-%release
BuildArch: noarch

%package -n openssl-engines
Summary: OpenSSL ENGINE interface modules
Group: System/Libraries
Requires: libssl%shlib_soversion = %version-%release

%package -n tsget
Summary: Time Stamping HTTP/HTTPS client
Group: Security/Networking 
BuildArch: noarch
Requires: libssl%shlib_soversion = %version-%release

%description
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

%description -n libcrypto%shlib_soversion
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the OpenSSL libcrypto shared library.

%description -n libssl%shlib_soversion
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the OpenSSL libssl shared library.

%description -n libssl-devel
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the OpenSSL include files and development libraries
required when building OpenSSL-based applications.

%description -n libssl-devel-static
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains static libraries required when developing
OpenSSL-based statically linked applications.

%description -n openssl
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the base OpenSSL cryptography and SSL/TLS tools.

%description -n openssl-doc
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the OpenSSL cryptography and SSL/TLS extra
documentation and demos required when developing applications.

%description -n openssl-engines
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

With OpenSSL 0.9.6, a new component was added to support alternative
cryptography implementations, most commonly for interfacing with external
crypto devices (eg. accelerator cards).  This component is called ENGINE,
and its presence in OpenSSL 0.9.6 (and subsequent bug-fix releases) caused
a little confusion as 0.9.6** releases were rolled in two versions,
a "standard" and an "engine" version.  In development for 0.9.7, the
ENGINE code has been merged into the main branch and is present in
the standard releases from 0.9.7 forwards.

There are currently following built-in ENGINE implementations:
- 4758cca: IBM 4758 CCA hardware support;
- aep: Aep hardware support;
- atalla: Atalla hardware support;
- chil: CHIL hardware support;
- cswift: CryptoSwift hardware support;
- gost: GOST (Russian cryptography standard) implementation;
- nuron: Nuron hardware support;
- padlock: VIA PadLock ACE support;
- sureware: SureWare hardware support;
- ubsec: UBSEC hardware support.

In addition, dynamic binding to external ENGINE implementations is
provided by a special ENGINE called "dynamic".

%description -n tsget
The tsget command can be used for sending a time stamp request, as
specified in RFC 3161, to a time stamp server over HTTP or HTTPS and
storing the time stamp response in a file.  This tool cannot be used for
creating the requests and verifying responses, you can use the OpenSSL
ts(1) command to do that.  tsget can send several requests to the server
without closing the TCP connection if more than one requests are specified
on the command line.

%prep
%setup -n openssl-%version
# Backports
%patch500 -p1
%patch501 -p1
%patch502 -p1
%patch503 -p1
%patch504 -p1
%patch505 -p1

# ALT patches
%patch01 -p1
%patch03 -p1
%patch04 -p1
%patch05 -p1

%patch101 -p1
#%%patch102 -p1 (different config)
%patch103 -p1
#%%patch104 -p1 (not needed)
%patch121 -p1
#%%patch131 -p1 (changes config)
%patch132 -p1
%patch133 -p1
#%%patch136 -p1 (why disable it?)
#%%patch137 -p1 (breaks tests; we have no reason to disable this curves, right?)
%patch138 -p1
%patch140 -p1
%patch141 -p1
#%%patch142 -p1 (not needed)
#%%patch143 -p1 (not sure)
#%%patch144 -p1 (not needed; FIPS)
%patch145 -p1
#%%patch146 -p1 (not needed; FIPS)
#%%patch148 -p1 (not needed)
#%%patch149 -p1 (new functionality; not sure)
#%%patch150 -p1 (new functionality; not sure)

find -type f -name \*.orig -delete
# Skip afalg test.
# This test fails when af_alg moudle is loaded, but with no aes_cbc support.
rm test/recipes/30-test_afalg.t

# Correct shared library name.
sed -i 's/\\\$(SHLIB_MAJOR)\.\\\$(SHLIB_MINOR)/\\$(VERSION)/g' Configure

%build
ADD_ARGS=%_os-%_arch
%ifarch %ix86
	ADD_ARGS=linux-elf
%ifarch i386
	ADD_ARGS="$ADD_ARGS 386"
%endif
%endif
%ifarch %arm
ADD_ARGS=linux-generic32
%endif
%ifarch x32
ADD_ARGS=linux-x32
%endif
%ifarch s390x
ADD_ARGS=linux64-s390x
%endif
%ifarch mips mipsel
ADD_ARGS=linux-mips32
%endif
%ifarch mips64 mips64el
ADD_ARGS=linux64-mips64
%endif
%ifarch riscv64 %e2k
ADD_ARGS=linux-generic64
%endif
%ifarch loongarch64
ADD_ARGS=linux64-loongarch64
%endif

if echo 'extern __uint128_t i;' |
   gcc %optflags -Werror -c -o/dev/null -xc -; then
	ADD_ARGS="enable-ec_nistp_64_gcc_128 $ADD_ARGS"
fi

# Correct compilation options.
%add_optflags -fno-strict-aliasing -Wa,--noexecstack

./Configure shared \
	--prefix=%prefix \
	--libdir=%_lib \
	--openssldir=%openssldir \
	--system-ciphers-file=%_sysconfdir/openssl/cipher-list.conf \
	enable-egd \
	enable-md2 \
	enable-rfc3779 \
	enable-ssl3 \
	zlib \
	$ADD_ARGS \
	%optflags \
#

make generate_crypto_objects
%make_build

# Make soname symlinks.
/sbin/ldconfig -nv .

# Save library timestamps for later check.
touch -r libcrypto.so.%shlib_soversion libcrypto-stamp
touch -r libssl.so.%shlib_soversion libssl-stamp

#LD_LIBRARY_PATH=`pwd` make rehash

%install
# The make_install macro doesn't work here.
make install \
	CC=%_sourcedir/cc.sh \
	DESTDIR=%buildroot \
	MANDIR=%_mandir

# Fail if one of shared libraries was rebuit.
if [ libcrypto.so.%shlib_soversion -nt libcrypto-stamp -o \
     libssl.so.%shlib_soversion -nt libssl-stamp ]; then
	echo 'Shared library was rebuilt by "make install".'
	exit 1
fi

# Fail if the openssl binary is statically linked against OpenSSL at this
# stage (which could happen if "make install" caused anything to rebuild).
LD_LIBRARY_PATH=`pwd` ldd %buildroot%_bindir/openssl |tee openssl.libs
grep -qw libssl openssl.libs
grep -qw libcrypto openssl.libs

# Install openssl-config script.
install -pDm755 %_sourcedir/openssl-config %buildroot%_bindir/openssl-config
subst -p 's,%%version,%version,g;s,%%openssldir,%openssldir,g' \
	%buildroot%_bindir/openssl-config

# Relocate shared libraries from %_libdir/ to /lib/.
mkdir -p %buildroot{/%_lib,%_libdir/openssl,%_sbindir}
for f in %buildroot%_libdir/*.so; do
	t=$(readlink "$f") || continue
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

# Relocate openssl.cnf from %%openssldir/ to %_sysconfdir/openssl/.
mkdir -p %buildroot%_sysconfdir/openssl
mv %buildroot%openssldir/openssl.cnf %buildroot%_sysconfdir/openssl/
ln -s -r %buildroot%_sysconfdir/openssl/openssl.cnf %buildroot%openssldir/

# Rename some man pages, fix references.
for f in passwd.1 config.5; do
	name="${f%%.*}"
	sect="${f##*.}"
	NAME=`printf %%s "$name" |tr '[:lower:]' '[:upper:]'`
	sed -i "s/\\<$NAME $sect\\>/SSL&/" %buildroot%_mandir/man"$sect/$f"
	mv -v %buildroot%_mandir/man"$sect"/{,ssl}"$f"
	find %buildroot%_mandir -type f -print0 |
		xargs -r0 grep -FZl "\\fI$name\\fR\\|($sect)" -- |
		xargs -r0 subst -p "s/\\\\fI$name\\\\fR\\\\|($sect)/\\\\fIssl$name\\\\fR\\\\|($sect)/" --
	find %buildroot%_mandir -type l |while read link; do
		[ "$(readlink -n "$link")" = "$f" ] || continue
		ln -sfv "ssl$f" "$link"
	done
done
# ln -s sslconfig.5 %buildroot%_mandir/man5/openssl.cnf.5

# Make backwards-compatibility symlink to ssleay.
ln -snf openssl %buildroot%_bindir/ssleay

# Install a makefile for generating keys and self-signed certs,
# and a script for generating them on the fly.
install -pDm644 %_sourcedir/Makefile.certificate \
	%buildroot%openssldir/certs/Makefile
install -pDm644 %_sourcedir/make-dummy-cert \
	%buildroot%openssldir/certs/make-dummy-cert

ln -s -r %buildroot%_datadir/ca-certificates/ca-bundle.crt \
	%buildroot%openssldir/cert.pem

%if_enabled tsget
mv %buildroot%openssldir/misc/tsget.pl %buildroot%_sbindir/
rm %buildroot%openssldir/misc/tsget
ln -s tsget.pl %buildroot%_sbindir/tsget
%else
rm %buildroot%openssldir/misc/tsget.pl
rm %buildroot%openssldir/misc/tsget
%endif

rm %buildroot%openssldir/openssl.cnf.dist
rm %buildroot%openssldir/ct_log_list.cnf.dist

%define docdir %_docdir/openssl-%version
mkdir -p %buildroot%docdir
install -pm644 CHANGES* LICENSE NEWS README* \
	%buildroot%docdir/
bzip2 -9 %buildroot%docdir/CHANGES*
cp -a demos doc %buildroot%docdir/
rm -rf %buildroot%docdir/doc/{apps,crypto,ssl}

# Create default cipher-list.conf from SSL_DEFAULT_CIPHER_LIST
sed -n -r 's,^#.*SSL_DEFAULT_CIPHER_LIST[[:space:]]+"([^"]+)",\1,p' \
	include/openssl/ssl.h > %buildroot%_sysconfdir/openssl/cipher-list.conf

%check
LD_LIBRARY_PATH=%buildroot/%_lib \
	OPENSSL_ENABLE_MD5_VERIFY= \
	OPENSSL_SYSTEM_CIPHERS_OVERRIDE=%buildroot%_sysconfdir/openssl/cipher-list.conf \
	make test V=1

%define _unpackaged_files_terminate_build 1

%files -n libcrypto%shlib_soversion
/%_lib/libcrypto*
%config(noreplace) %_sysconfdir/openssl/openssl.cnf
%dir %_sysconfdir/openssl/
%dir %openssldir
%openssldir/*.cnf
%openssldir/*.pem
%dir %docdir
%docdir/[A-Z]*

%files -n libssl%shlib_soversion
%config(noreplace) %_sysconfdir/openssl/cipher-list.conf
%dir %_sysconfdir/openssl/
/%_lib/libssl*

%files -n libssl-devel
%_bindir/openssl-config
%_libdir/*.so
%_libdir/pkgconfig/*
%_includedir/*

%files -n libssl-devel-static
%_libdir/*.a

%files -n openssl
%_bindir/*
%dir %openssldir
%openssldir/misc
%openssldir/certs
%dir %attr(700,root,root) %openssldir/private
%_mandir/man[157]/*
%if_enabled tsget
%exclude %_man1dir/tsget.*
%exclude %_man1dir/openssl-tsget.*
%endif

%files -n openssl-doc
%dir %docdir
%docdir/[a-z]*
%_man3dir/*

%files -n openssl-engines
%_libdir/openssl

%if_enabled tsget
%files -n tsget
%_sbindir/tsget
%_sbindir/tsget.pl
%_man1dir/tsget.*
%_man1dir/openssl-tsget.*
%endif

%changelog
