%global oname aodh
%def_without doc

Name: openstack-%oname
Version: 16.0.0
Release: alt1.p10

Summary: OpenStack Telemetry Alarming

Group: System/Servers
License: Apache-2.0
Url: http://docs.openstack.org/developer/%oname

Source: https://tarballs.openstack.org/%oname/%oname-%version.tar.gz

BuildArch: noarch

Source2: aodh.logrotate
Source6: aodh.conf
Source9: %name.tmpfiles
Source10: %name-api.service
Source11: %name-evaluator.service
Source12: %name-notifier.service
Source13: %name-expirer.service
Source14: %name-listener.service

Source110: %name-api.init
Source111: %name-evaluator.init
Source112: %name-notifier.init
Source113: %name-expirer.init
Source114: %name-listener.init

Requires: python3-module-PasteDeploy
Requires(pre):    shadow-utils

BuildRequires: crudini
BuildRequires: webserver-common
BuildRequires: rpm-build-webserver-common
BuildRequires: rpm-macros-apache2

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-tenacity >= 3.2.1
BuildRequires: python3-module-croniter >= 0.3.4
BuildRequires: python3-module-futurist >= 0.11.0
BuildRequires: python3-module-jsonschema >= 3.2.0
BuildRequires: python3-module-keystonemiddleware >= 5.1.0
BuildRequires: python3-module-gnocchiclient >= 6.0.0
BuildRequires: python3-module-lxml >= 2.3
BuildRequires: python3-module-oslo.db >= 4.8.0
BuildRequires: python3-module-oslo.config >= 6.8.0
BuildRequires: python3-module-oslo.i18n >= 1.5.0
BuildRequires: python3-module-oslo.log >= 4.3.0
BuildRequires: python3-module-oslo.reports >= 1.18.0
BuildRequires: python3-module-oslo.policy >= 3.7.0
BuildRequires: python3-module-oslo.upgradecheck >= 1.3.0
BuildRequires: python3-module-PasteDeploy >= 1.5.0
BuildRequires: python3-module-pbr >= 2.0.0
BuildRequires: python3-module-pecan >= 0.8.0
BuildRequires: python3-module-oslo.messaging >= 5.2.0
BuildRequires: python3-module-oslo.middleware >= 3.22.0
BuildRequires: python3-module-oslo.utils >= 3.5.0
BuildRequires: python3-module-keystoneclient >= 1.6.0
BuildRequires: python3-module-pytz >= 2013.6
BuildRequires: python3-module-requests >= 2.5.2
BuildRequires: python3-module-stevedore >= 1.5.0
BuildRequires: python3-module-sqlalchemy >= 1.4.1
BuildRequires: python3-module-tooz >= 1.28.0
BuildRequires: python3-module-voluptuous >= 0.8.10
BuildRequires: python3-module-webob >= 1.2.3
BuildRequires: python3-module-wsme >= 0.8
BuildRequires: python3-module-cachetools >= 1.1.6
BuildRequires: python3-module-cotyledon
BuildRequires: python3-module-keystoneauth1 >= 2.1
BuildRequires: python3-module-debtcollector >= 1.2.0
BuildRequires: python3-module-octaviaclient >= 1.8.0
BuildRequires: python3-module-dateutil
BuildRequires: python3-module-heatclient >= 1.17.0

%if_with doc
BuildRequires: python3-module-openstackdocstheme >= 2.2.1
BuildRequires: python3-module-reno >= 3.1.0
BuildRequires: python3-module-sphinx >= 2.0.0
BuildRequires: python3-module-sphinxcontrib-httpdomain
BuildRequires: python3-module-sphinxcontrib-pecanwsme >= 0.10.0
%endif

# /proc need for generate sample config fix "nova.cmd.novncproxy: [Errno 2] No such file or directory: '/proc/stat'"
BuildRequires: /proc

%description
Aodh is the alarm engine of the Ceilometer project.

%package -n python3-module-%oname
Summary: OpenStack aodh python libraries
Group: Development/Python3
Requires: python3-module-tenacity >= 3.2.1
Requires: python3-module-croniter >= 0.3.4
Requires: python3-module-futurist >= 0.11.0
Requires: python3-module-jsonschema >= 3.2.0
Requires: python3-module-keystonemiddleware = 10.2.0
Requires: python3-module-gnocchiclient >= 6.0.0
Requires: python3-module-lxml >= 2.3
Requires: python3-module-oslo.db >= 12.2.0 python3-module-oslo.db <= 12.3.2
Requires: python3-module-oslo.config >= 9.1.0 python3-module-oslo.config <= 9.1.1
Requires: python3-module-oslo.i18n = 6.0.0
Requires: python3-module-oslo.log >= 5.1.0 python3-module-oslo.log <= 5.2.0
Requires: python3-module-oslo.reports = 3.0.0
Requires: python3-module-oslo.policy >= 4.1.0 python3-module-oslo.policy <= 4.1.1
Requires: python3-module-oslo.upgradecheck >= 2.1.0 python3-module-oslo.upgradecheck <= 2.1.1
Requires: python3-module-PasteDeploy >= 1.5.0
Requires: python3-module-pbr >= 2.0.0
Requires: python3-module-pecan >= 0.8.0
Requires: python3-module-oslo.messaging >= 14.1.0 python3-module-oslo.messaging <= 14.2.2
Requires: python3-module-oslo.middleware >= 5.1.0 python3-module-oslo.middleware <= 5.1.1
Requires: python3-module-oslo.utils = 6.1.0
Requires: python3-module-keystoneclient = 5.1.0
Requires: python3-module-pytz >= 2013.6
Requires: python3-module-requests >= 2.5.2
Requires: python3-module-stevedore >= 4.1.0 python3-module-stevedore <= 5.0.0
Requires: python3-module-sqlalchemy >= 1.4.1
Requires: python3-module-tooz >= 1.28.0
Requires: python3-module-voluptuous >= 0.8.10
Requires: python3-module-webob >= 1.2.3
Requires: python3-module-wsme >= 0.8
Requires: python3-module-cachetools >= 1.1.6
Requires: python3-module-cotyledon
Requires: python3-module-keystoneauth1 >= 5.1.0 python3-module-keystoneauth1 <= 5.1.2
Requires: python3-module-debtcollector >= 1.2.0
Requires: python3-module-octaviaclient >= 3.2.0 python3-module-octaviaclient <= 3.4.0
Requires: python3-module-dateutil
Requires: python3-module-heatclient = 3.2.0

%description -n python3-module-%oname
OpenStack aodh provides API and services for managing alarms.

This package contains the aodh python3 library.

%package common
Summary: Components common to all OpenStack aodh services
Group: System/Servers

Requires: python3-module-aodh = %version-%release
Requires: python3-module-ceilometerclient

%description common
OpenStack aodh provides API and services for managing alarms.

%package api
Summary: OpenStack aodh api
Group: System/Servers

Requires: %name-common = %version-%release
Requires: python3-module-ceilometerclient

%description api
OpenStack aodh provides API and servicesfor managing alarms.

This package contains the aodh API service.

%package evaluator
Summary: OpenStack aodh evaluator
Group: System/Servers

Requires: %name-common = %version-%release

%description evaluator
OpenStack aodh provides API and services for managing alarms.

This package contains the aodh evaluator service.

%package notifier
Summary: OpenStack aodh notifier
Group: System/Servers

Requires: %name-common = %version-%release

%description notifier
OpenStack aodh provides API and services for managing alarms.

This package contains the aodh notifier service.

%package listener
Summary: OpenStack aodh listener
Group: System/Servers

Requires: %name-common = %version-%release

%description listener
OpenStack aodh provides API and services for managing alarms.

This package contains the aodh listener service.

%package expirer
Summary: OpenStack aodh expirer
Group: System/Servers

Requires: %name-common = %version-%release

%description expirer
OpenStack aodh provides API and services for managing alarms.

This package contains the aodh expirer service.

%package -n python3-module-%oname-tests
Summary: Aodh tests
Group: Development/Python3
Requires: python3-module-aodh = %version-%release

%description -n python3-module-%oname-tests
OpenStack aodh provides API and services for managing alarms.

This package contains the Aodh test files.

%prep
%setup -n %oname-%version

find . \( -name .gitignore -o -name .placeholder \) -delete

find aodh -name \*.py -exec sed -i '/\/usr\/bin\/env python/{d;q}' {} +

sed -i '/setup_requires/d; /install_requires/d; /dependency_links/d' setup.py

rm -rf {test-,}requirements.txt tools/{pip,test}-requires

%build
export PBR_VERSION=%version
%pyproject_build
# Generate config file
PYTHONPATH=. oslo-config-generator --config-file=aodh/cmd/aodh-config-generator.conf --output-file aodh.conf.sample

# Generate i18n files
#python setup.py compile_catalog -d build/lib/%oname/locale

%install
%pyproject_install

# Install config files
install -d -m 755 %buildroot%_sysconfdir/aodh
install -d -m 755 %buildroot%_sysconfdir/aodh/aodh.conf.d
install -p -D -m 640 aodh.conf.sample %buildroot%_sysconfdir/aodh/aodh.conf
install -p -D -m 640 aodh/api/api-paste.ini %buildroot%_sysconfdir/aodh/api-paste.ini

# Setup directories
install -d -m 755 %buildroot%_sharedstatedir/aodh
install -d -m 755 %buildroot%_sharedstatedir/aodh/tmp
install -d -m 755 %buildroot%_logdir/aodh

cp -r aodh/storage/sqlalchemy/alembic/ %buildroot%python3_sitelibdir/aodh/storage/sqlalchemy/alembic/

# Install pid directory
install -d -m 775 %buildroot%_runtimedir/aodh
install -p -D -m 644 %SOURCE9 %buildroot%_tmpfilesdir/%name.conf

# Install logrotate
install -p -D -m 644 %SOURCE2 %buildroot%_sysconfdir/logrotate.d/%name

# Install systemd unit services
install -p -D -m 644 %SOURCE10 %buildroot%_unitdir/%name-api.service
install -p -D -m 644 %SOURCE11 %buildroot%_unitdir/%name-evaluator.service
install -p -D -m 644 %SOURCE12 %buildroot%_unitdir/%name-notifier.service
install -p -D -m 644 %SOURCE13 %buildroot%_unitdir/%name-expirer.service
install -p -D -m 644 %SOURCE14 %buildroot%_unitdir/%name-listener.service

# Install sysv init scripts
install -p -D -m 755 %SOURCE110 %buildroot%_initdir/%name-api
install -p -D -m 755 %SOURCE111 %buildroot%_initdir/%name-evaluator
install -p -D -m 755 %SOURCE112 %buildroot%_initdir/%name-notifier
install -p -D -m 755 %SOURCE113 %buildroot%_initdir/%name-expirer
install -p -D -m 755 %SOURCE114 %buildroot%_initdir/%name-listener

# Install sample HTTPD integration files
install -p -D -m 644 aodh/api/app.wsgi %buildroot%_datadir/aodh/aodh.wsgi

install -m 0644 -D -p %SOURCE6 %buildroot%apache2_sites_available/openstack-aodh.conf
mkdir -p %buildroot%apache2_sites_enabled
touch %buildroot%apache2_sites_enabled/openstack-aodh.conf
mkdir -p %buildroot%webserver_cgibindir
ln -s %_datadir/aodh/aodh.wsgi %buildroot%webserver_cgibindir/aodh-wsgi

### set default configuration
%define aodh_conf %buildroot%_sysconfdir/aodh/aodh.conf.d/010-aodh.conf
crudini --set %aodh_conf DEFAULT log_dir /var/log/aodh
crudini --set %aodh_conf DEFAULT state_path /var/lib/aodh
crudini --set %aodh_conf oslo_concurrency lock_path /var/run/aodh

# Install i18n .mo files (.po and .pot are not required)
#install -d -m 755 %buildroot%_datadir
#rm -f %buildroot%python_sitelibdir/%oname/locale/*/LC_*/%{oname}*po
#rm -f %buildroot%python_sitelibdir/%oname/locale/*pot
#mv %buildroot%python_sitelibdir/%oname/locale %buildroot%_datadir/locale

# Find language files
#%find_lang %oname --all-name

# Remove unused files
rm -fr %buildroot/usr/etc

%pre common
%_sbindir/groupadd -r -f aodh 2>/dev/null ||:
%_sbindir/useradd -r -g aodh -G aodh  -c 'OpenStack aodh Daemons' \
        -s /sbin/nologin  -d %_sharedstatedir/aodh aodh 2>/dev/null ||:

%post -n %name-api
%post_service %name-api

%preun -n %name-api
%preun_service %name-api

%post -n %name-evaluator
%post_service %name-evaluator

%preun -n %name-evaluator
%preun_service %name-evaluator

%post -n %name-notifier
%post_service  %name-notifier

%preun -n %name-notifier
%preun_service %name-notifier

%post -n %name-listener
%post_service %name-listener

%preun -n %name-listener
%preun_service %name-listener

%post -n %name-expirer
%post_service %name-expirer

%preun -n %name-expirer
%preun_service %name-expirer

%files -n python3-module-aodh
%_bindir/*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests

%files -n python3-module-aodh-tests
%python3_sitelibdir/*/tests

%files common
#-f %oname.lang
%doc README.rst
%dir %_sysconfdir/aodh
%dir %_sysconfdir/aodh/aodh.conf.d
%config(noreplace) %attr(640, root, aodh) %_sysconfdir/aodh/aodh.conf
%config(noreplace) %attr(640, root, aodh) %_sysconfdir/aodh/api-paste.ini
%config(noreplace) %attr(640, root, aodh) %_sysconfdir/aodh/aodh.conf.d/010-aodh.conf
%config(noreplace) %_sysconfdir/logrotate.d/%name
%_tmpfilesdir/%name.conf

%dir %attr(0770, root, aodh) %_logdir/aodh
%dir %attr(0775, root, aodh) %_runtimedir/aodh
%dir %attr(0755, aodh, aodh) %_sharedstatedir/aodh
#%dir %attr(0755, aodh, aodh) %_cachedir/aodh

%files api
%_unitdir/%name-api.service
%_initdir/%name-api
%dir %_datadir/aodh
%_datadir/aodh/*
%config(noreplace) %apache2_sites_available/*.conf
%ghost %apache2_sites_enabled/*.conf
%webserver_cgibindir/*

%files evaluator
%_unitdir/%name-evaluator.service
%_initdir/%name-evaluator

%files notifier
%_unitdir/%name-notifier.service
%_initdir/%name-notifier

%files listener
%_unitdir/%name-listener.service
%_initdir/%name-listener

%files expirer
%_unitdir/%name-expirer.service
%_initdir/%name-expirer

%changelog
