%def_without doc
%def_without tests
%define oname cinder
%add_python_req_skip hp3parclient

Name: openstack-%oname
Epoch: 1
Version: 22.1.1
Release: alt1.p10

Summary: OpenStack Volume service

Group: System/Servers
License: ASL 2.0
Url: http://docs.openstack.org/developer/%oname

Source: https://tarballs.openstack.org/%oname/%oname-%version.tar
Source1: cinder-dist.conf
Source2: cinder.logrotate
Source3: cinder-tgt.conf
Source4: %name.tmpfiles
Source5: %name.conf
Source10: openstack-cinder-api.service
Source11: openstack-cinder-scheduler.service
Source12: openstack-cinder-volume.service
Source13: openstack-cinder-backup.service

Source110: openstack-cinder-api.init
Source111: openstack-cinder-scheduler.init
Source112: openstack-cinder-volume.init
Source113: openstack-cinder-backup.init

Source20: cinder-sudoers

BuildArch: noarch

BuildRequires(pre): rpm-macros-apache2
BuildRequires: /proc
BuildRequires: webserver-common
BuildRequires: rpm-build-webserver-common
BuildRequires: rpm-macros-apache2
BuildRequires: git-core
BuildRequires: crudini
BuildRequires: graphviz

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 5.8.0
BuildRequires: python3-module-decorator >= 4.4.2
BuildRequires: python3-module-eventlet >= 0.30.1
BuildRequires: python3-module-greenlet >= 0.4.16
BuildRequires: python3-module-httplib2 >= 0.18.1
BuildRequires: python3-module-importlib-metadata >= 3.1.1
BuildRequires: python3-module-iso8601 >= 0.1.12
BuildRequires: python3-module-jsonschema >= 3.2.0
BuildRequires: python3-module-keystoneauth1 >= 4.2.1
BuildRequires: python3-module-keystonemiddleware >= 9.1.0
BuildRequires: python3-module-lxml >= 4.5.2
BuildRequires: python3-module-oauth2client >= 4.1.3
BuildRequires: python3-module-oslo.config >= 8.3.2
BuildRequires: python3-module-oslo.concurrency >= 4.5.0
BuildRequires: python3-module-oslo.context >= 3.4.0
BuildRequires: python3-module-oslo.db >= 11.0.0
BuildRequires: python3-module-oslo.log >= 4.6.1
BuildRequires: python3-module-oslo.messaging >= 14.1.0
BuildRequires: python3-module-oslo.middleware >= 4.1.1
BuildRequires: python3-module-oslo.policy >= 3.8.1
BuildRequires: python3-module-oslo.privsep >= 2.6.2
BuildRequires: python3-module-oslo.reports >= 2.2.0
BuildRequires: python3-module-oslo.rootwrap >= 6.2.0
BuildRequires: python3-module-oslo.serialization >= 4.2.0
BuildRequires: python3-module-oslo.service >= 2.8.0
BuildRequires: python3-module-oslo.upgradecheck >= 1.1.1
BuildRequires: python3-module-oslo.utils >= 4.12.1
BuildRequires: python3-module-oslo.versionedobjects >= 2.4.0
BuildRequires: python3-module-osprofiler >= 3.4.0
BuildRequires: python3-module-packaging >= 20.4
BuildRequires: python3-module-paramiko >= 2.7.2
BuildRequires: python3-module-paste >= 3.4.3
BuildRequires: python3-module-PasteDeploy >= 2.1.0
BuildRequires: python3-module-psutil >= 5.7.2
BuildRequires: python3-module-pyparsing >= 2.4.7
BuildRequires: python3-module-barbicanclient >= 5.0.1
BuildRequires: python3-module-glanceclient >= 3.2.2
BuildRequires: python3-module-keystoneclient >= 4.1.1
BuildRequires: python3-module-novaclient >= 17.2.1
BuildRequires: python3-module-swiftclient >= 3.10.1
BuildRequires: python3-module-pytz >= 2020.1
BuildRequires: python3-module-requests >= 2.25.1
BuildRequires: python3-module-routes >= 2.4.1
BuildRequires: python3-module-taskflow >= 4.5.0
BuildRequires: python3-module-rtslib >= 2.1.74
BuildRequires: python3-module-six >= 1.15.0
BuildRequires: python3-module-sqlalchemy >= 1.4.23
BuildRequires: python3-module-migrate >= 0.13.0
BuildRequires: python3-module-stevedore >= 3.2.2
BuildRequires: python3-module-tabulate >= 0.8.7
BuildRequires: python3-module-tenacity >= 6.3.1
BuildRequires: python3-module-webob >= 1.8.6
BuildRequires: python3-module-oslo.i18n >= 5.1.0
BuildRequires: python3-module-oslo.vmware >= 3.10.0
BuildRequires: python3-module-os-brick >= 6.0.0
BuildRequires: python3-module-os-win >= 5.5.0
BuildRequires: python3-module-tooz >= 2.8.0
BuildRequires: python3-module-google-api-client >= 1.11.0
BuildRequires: python3-module-castellan >= 3.7.0
BuildRequires: python3-module-cryptography >= 3.1
BuildRequires: python3-module-cursive >= 0.2.2
BuildRequires: python3-module-zstd >= 1.4.5.1
BuildRequires: python3-module-boto3 >= 1.18.49

%if_with tests
BuildRequires: python3-module-hacking >= 5.0.0 python3-module-hacking < 5.1.0
BuildRequires: python3-module-flake8-import-order
BuildRequires: python3-module-flake8-logging-format >= 0.6.0
BuildRequires: python3-module-stestr >= 3.2.1
BuildRequires: python3-module-coverage >= 5.5
BuildRequires: python3-module-ddt >= 1.4.4
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-oslotest >= 4.5.0
BuildRequires: python3-module-PyMySQL >= 0.10.0
BuildRequires: python3-module-psycopg2 >= 2.8.5
BuildRequires: python3-module-SQLAlchemy-Utils >= 0.37.8
BuildRequires: python3-module-testtools >= 2.4.0
BuildRequires: python3-module-doc8 >= 0.8.1
BuildRequires: python3-module-mypy >= 0.981
BuildRequires: python3-module-moto >= 2.2.5
%endif

%if_with doc
BuildRequires: python3-module-openstackdocstheme >= 2.2.7
BuildRequires: python3-module-reno >= 3.2.0
BuildRequires: python3-module-sphinx >= 3.5.1
BuildRequires: python3-module-Pygments >= 2.6.1
BuildRequires: python3-module-os-api-ref >= 2.1.0
BuildRequires: python3-module-sphinxcontrib-apidoc >= 0.3.0
BuildRequires: python3-module-sphinx-feature-classification >= 1.1.0
BuildRequires: python3-module-whereto >= 0.4.0
%endif

Requires: python3-module-cinder = %EVR

Requires(pre): shadow-utils
Requires: lvm2
Requires: targetcli
Requires: python3-module-rtslib
Requires: sysfsutils
Requires: sudo
Requires: qemu-img

%description
OpenStack Volume (codename Cinder) provides services to manage and
access block storage volumes for use by Virtual Machine instances.

%package -n python3-module-%oname
Summary: OpenStack Volume Python libraries
Group: Development/Python3

Requires: python3-module-pbr >= 5.8.0
Requires: python3-module-decorator >= 4.4.2
Requires: python3-module-eventlet >= 0.30.1
Requires: python3-module-greenlet >= 0.4.16
Requires: python3-module-httplib2 >= 0.18.1
Requires: python3-module-importlib-metadata >= 3.1.1
Requires: python3-module-iso8601 >= 0.1.12
Requires: python3-module-jsonschema >= 3.2.0
Requires: python3-module-keystoneauth1 >= 5.1.0 python3-module-keystoneauth1 <= 5.1.2
Requires: python3-module-keystonemiddleware = 10.2.0
Requires: python3-module-lxml >= 4.5.2
Requires: python3-module-oauth2client >= 4.1.3
Requires: python3-module-oslo.config >= 9.1.0 python3-module-oslo.config <= 9.1.1
Requires: python3-module-oslo.concurrency >= 5.1.0 python3-module-oslo.concurrency <= 5.1.1
Requires: python3-module-oslo.context >= 5.1.0 python3-module-oslo.context <= 5.1.1
Requires: python3-module-oslo.db >= 12.2.0 python3-module-oslo.db <= 12.3.2
Requires: python3-module-oslo.log >= 5.1.0 python3-module-oslo.log <= 5.2.0
Requires: python3-module-oslo.messaging >= 14.1.0 python3-module-oslo.messaging <= 14.2.2
Requires: python3-module-oslo.middleware >= 5.1.0 python3-module-oslo.middleware <= 5.1.1
Requires: python3-module-oslo.policy >= 4.1.0 python3-module-oslo.policy <= 4.1.1
Requires: python3-module-oslo.privsep = 3.1.0
Requires: python3-module-oslo.reports = 3.0.0
Requires: python3-module-oslo.rootwrap >= 7.0.0 python3-module-oslo.rootwrap <= 7.0.1
Requires: python3-module-oslo.serialization >= 5.1.0 python3-module-oslo.serialization <= 5.1.1
Requires: python3-module-oslo.service >= 3.1.0 python3-module-oslo.service <= 3.1.1
Requires: python3-module-oslo.upgradecheck >= 2.1.0 python3-module-oslo.upgradecheck <= 2.1.1
Requires: python3-module-oslo.utils = 6.1.0
Requires: python3-module-oslo.versionedobjects = 3.1.0
Requires: python3-module-osprofiler >= 3.4.0
Requires: python3-module-packaging >= 20.4
Requires: python3-module-paramiko >= 2.7.2
Requires: python3-module-paste >= 3.4.3
Requires: python3-module-PasteDeploy >= 2.1.0
Requires: python3-module-psutil >= 5.7.2
Requires: python3-module-pyparsing >= 2.4.7
Requires: python3-module-barbicanclient = 5.5.0
Requires: python3-module-glanceclient >= 4.2.0 python3-module-glanceclient <= 4.3.0
Requires: python3-module-keystoneclient = 5.1.0
Requires: python3-module-novaclient >= 18.2.0 python3-module-novaclient <= 18.3.0
Requires: python3-module-swiftclient = 4.2.0
Requires: python3-module-pytz >= 2020.1
Requires: python3-module-requests >= 2.25.1
Requires: python3-module-routes >= 2.4.1
Requires: python3-module-taskflow = 5.1.0
Requires: python3-module-rtslib >= 2.1.74
Requires: python3-module-six >= 1.15.0
Requires: python3-module-sqlalchemy >= 1.4.23
Requires: python3-module-migrate >= 0.13.0
Requires: python3-module-stevedore >= 4.1.0 python3-module-stevedore <= 5.0.0
Requires: python3-module-tabulate >= 0.8.7
Requires: python3-module-tenacity >= 6.3.1
Requires: python3-module-webob >= 1.8.6
Requires: python3-module-oslo.i18n = 6.0.0
Requires: python3-module-oslo.vmware >= 4.1.0 python3-module-oslo.vmware <= 4.1.1
Requires: python3-module-os-brick >= 6.2.0 python3-module-os-brick <= 6.2.2
Requires: python3-module-os-win >= 5.8.0 python3-module-os-win <= 5.9.0
Requires: python3-module-tooz >= 2.8.0
Requires: python3-module-google-api-client >= 1.11.0
Requires: python3-module-castellan = 4.1.0
Requires: python3-module-cryptography >= 3.1
Requires: python3-module-cursive >= 0.2.2
Requires: python3-module-zstd >= 1.4.5.1
Requires: python3-module-boto3 >= 1.18.49
Requires: python3-module-botocore

AutoReq: no

%description -n python3-module-%oname
OpenStack Volume (codename Cinder) provides services to manage and
access block storage volumes for use by Virtual Machine instances.

This package contains the cinder Python library.

%if_with tests
%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3

%description -n python3-module-%oname-tests
This package contains tests for %oname.
%endif

%if_with doc
%package doc
Summary: Documentation for OpenStack Volume
Group: Development/Documentation

%description doc
OpenStack Volume (codename Cinder) provides services to manage and
access block storage volumes for use by Virtual Machine instances.

This package contains documentation files for cinder.
%endif

%prep
%setup -n %oname-%version

find . \( -name .gitignore -o -name .placeholder \) -delete

find cinder -name \*.py -exec sed -i '/\/usr\/bin\/env python/{d;q}' {} +

grep -rl requests.packages.urllib3 | xargs sed -i "s/requests.packages.urllib3/urllib3/g"

# Remove the requirements file so that pbr hooks don't add it
# to distutils requires_dist config
rm -rf {test-,}requirements.txt tools/{pip,test}-requires

%build
export PBR_VERSION=%version
%pyproject_build
# Generate config file
oslo-config-generator --config-file=tools/config/cinder-config-generator.conf
oslopolicy-sample-generator --config-file=tools/config/cinder-policy-generator.conf

%if_with doc
PYTHONPATH=. python3 setup.py build_sphinx
# Fix hidden-file-or-dir warnings
rm -fr build/sphinx/html/.buildinfo
%endif

%install
%pyproject_install

# Setup directories
install -d -m 755 %buildroot%_sharedstatedir/cinder
install -d -m 755 %buildroot%_cachedir/cinder
install -d -m 775 %buildroot%_logdir/cinder

# Install config files
install -d -m 755 %buildroot%_sysconfdir/cinder
install -d -m 755 %buildroot%_sysconfdir/cinder/cinder.conf.d
install -d -m 755 %buildroot%_sysconfdir/cinder/cinder-volume.conf.d
install -d -m 755 %buildroot%_sysconfdir/cinder/volumes
install -d -m 755 %buildroot%_sysconfdir/cinder/rootwrap.d

mkdir -p %buildroot%_man1dir
install -p -D -m 640 etc/cinder/cinder.conf.sample %buildroot%_sysconfdir/cinder/cinder.conf
install -p -D -m 640 etc/cinder/logging_sample.conf %buildroot%_sysconfdir/cinder/logging.conf
install -p -D -m 640 etc/cinder/logging_sample.conf %buildroot%_sysconfdir/cinder/resource_filters.json
install -p -D -m 644 etc/cinder/{api-paste.ini,rootwrap.conf} %buildroot%_sysconfdir/cinder/
install -p -D -m 644 etc/cinder/rootwrap.d/* %buildroot%_sysconfdir/cinder/rootwrap.d/

cp -r cinder/locale %buildroot%python3_sitelibdir/cinder/locale
cp -r cinder/db/migrations %buildroot%python3_sitelibdir/cinder/db/migrations
cp cinder/db/legacy_migrations/migrate.cfg %buildroot%python3_sitelibdir/cinder/db/legacy_migrations/migrate.cfg
cp cinder/api/openstack/rest_api_version_history.rst %buildroot%python3_sitelibdir/cinder/api/openstack/rest_api_version_history.rst
cp cinder/db/migrations/script.py.mako %buildroot%python3_sitelibdir/cinder/db/migrations/script.py.mako
cp cinder/db/alembic.ini %buildroot%python3_sitelibdir/cinder/db/alembic.ini

# Install config files
install -p -D -m 644 %SOURCE3 %buildroot%_sysconfdir/tgt/conf.d/cinder.conf

# Symlinks to rootwrap config files
for filter in %_sysconfdir/os-brick/rootwrap.d/*.filters; do
ln -s $filter %buildroot%_sysconfdir/cinder/rootwrap.d/
done

# Install initscripts for services
install -p -D -m 644 %SOURCE10 %buildroot%_unitdir/openstack-cinder-api.service
install -p -D -m 644 %SOURCE11 %buildroot%_unitdir/openstack-cinder-scheduler.service
install -p -D -m 644 %SOURCE12 %buildroot%_unitdir/openstack-cinder-volume.service
install -p -D -m 644 %SOURCE13 %buildroot%_unitdir/openstack-cinder-backup.service
install -p -D -m 644 %SOURCE4 %buildroot%_tmpfilesdir/%name.conf

install -p -D -m 755 %SOURCE110 %buildroot%_initdir/openstack-cinder-api
install -p -D -m 755 %SOURCE111 %buildroot%_initdir/openstack-cinder-scheduler
install -p -D -m 755 %SOURCE112 %buildroot%_initdir/openstack-cinder-volume
install -p -D -m 755 %SOURCE113 %buildroot%_initdir/openstack-cinder-backup

# Install sudoers
install -p -D -m 400 %SOURCE20 %buildroot%_sysconfdir/sudoers.d/cinder

# Install logrotate
install -p -D -m 644 %SOURCE2 %buildroot%_sysconfdir/logrotate.d/openstack-cinder

# Install pid directory
install -d -m 755 %buildroot%_runtimedir/cinder

# Install sample HTTPD integration files
install -p -D -m 644 cinder/wsgi/wsgi.py %buildroot%_datadir/cinder/cinder.wsgi
install -p -D -m 644 etc/cinder/api-httpd.conf  %buildroot%_datadir/cinder/

# apache2 settings
install -m 0644 -D -p %SOURCE5 %buildroot%apache2_sites_available/openstack-cinder-api.conf
mkdir -p %buildroot%apache2_sites_enabled
touch %buildroot%apache2_sites_enabled/openstack-cinder-api.conf
mkdir -p %buildroot%webserver_cgibindir
ln -s %_datadir/cinder/cinder.wsgi %buildroot%webserver_cgibindir/cinder-osapi_volume

### set default configuration (mostly applies to package-only setups and quickstart, i.e. not generally crowbar)
%define cinder_conf %buildroot%_sysconfdir/cinder/cinder.conf.d/010-cinder.conf
crudini --set %cinder_conf DEFAULT log_dir /var/log/cinder
crudini --set %cinder_conf DEFAULT state_path /var/lib/cinder
crudini --set %cinder_conf oslo_concurrency lock_path /var/run/cinder

# cleanup
rm -rf %buildroot/usr/etc

%pre
# 165:165 for ceilometer (openstack-cinder)
%_sbindir/groupadd -r -g 165 -f cinder 2>/dev/null ||:
%_sbindir/useradd -r -u 165 -g cinder -G cinder,nobody,wheel  -c 'OpenStack Cinder Daemons' \
        -s /sbin/nologin  -d %_sharedstatedir/cinder cinder 2>/dev/null ||:

%post
%post_service %name-volume
%post_service %name-api
%post_service %name-scheduler
%post_service %name-backup

%preun
%preun_service %name-volume
%preun_service %name-api
%preun_service %name-scheduler
%preun_service %name-backup

%files
%doc LICENSE
%dir %_sysconfdir/cinder
%dir %_sysconfdir/cinder/cinder.conf.d
%dir %_sysconfdir/cinder/rootwrap.d
%config(noreplace) %attr(0640, root, cinder) %_sysconfdir/cinder/cinder.conf
%config(noreplace) %attr(0640, root, cinder) %_sysconfdir/cinder/cinder.conf.d/010-cinder.conf
%config(noreplace) %attr(0640, root, cinder) %_sysconfdir/cinder/logging.conf
%config(noreplace) %attr(0640, root, cinder) %_sysconfdir/cinder/resource_filters.json
%config %attr(0640, root, cinder) %_sysconfdir/cinder/api-paste.ini
%config %_sysconfdir/cinder/rootwrap.conf
%config(noreplace) %_sysconfdir/logrotate.d/openstack-cinder
%config(noreplace) %_sysconfdir/sudoers.d/cinder
%config(noreplace) %_sysconfdir/tgt/conf.d/cinder.conf
%config(noreplace) %_sysconfdir/cinder/rootwrap.d/*
%dir %_datadir/cinder
%_datadir/cinder/cinder.wsgi
%_datadir/cinder/*.conf
%config(noreplace) %apache2_sites_available/*.conf
%ghost %apache2_sites_enabled/*.conf
%webserver_cgibindir/*

%dir %attr(0770, root, cinder) %_logdir/cinder
%dir %attr(0755, root, cinder) %_runtimedir/cinder
%dir %attr(0775, root, cinder) %_sysconfdir/cinder/volumes

%_unitdir/*
%_initdir/*
%_tmpfilesdir/*

%dir %attr(0775, root, cinder) %_sharedstatedir/cinder
%dir %attr(0775, root, cinder) %_cachedir/cinder

%files -n python3-module-%oname
%_bindir/*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/tests

%if_with tests
%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/tests
%endif

%if_with doc
%files doc
%doc ../python3/build/sphinx/html
%endif

%changelog
