Name: openxcom
Version: 1.0_2021.05.13
Release: alt1
Summary: OpenXcom is an open-source clone of the original X-COM
License: GPLv3+
Group: Games/Strategy
Url: http://openxcom.org/

Source: https://github.com/SupSuper/OpenXcom/%name-%version.tar
Source2: openxcom16.png
Source3: openxcom32.png
Patch: openxcom-man6.patch

# Automatically added by buildreq on Sat May 31 2014
# optimized out: boost-devel-headers cmake-modules libGL-devel libGLU-devel libSDL-devel libX11-devel libcloog-isl4 libstdc++-devel libyaml-cpp0 pkg-config xorg-kbproto-devel xorg-xproto-devel
BuildRequires: cmake gcc-c++ libSDL_gfx-devel libSDL_image-devel libSDL_mixer-devel libyaml-cpp0-devel

# Recommends
Requires: zenity

%description
OpenXcom is an open-source clone of the popular UFO: Enemy Unknown
(X-Com: UFO Defense in USA) videogame by Microprose, licensed
under the GPL and written in C++ / SDL.

%prep
%setup -n %name-%version
%patch -p1

%build
cmake --debug-output -D CMAKE_INSTALL_PREFIX="/usr" -D CMAKE_CXX_FLAGS="%optflags" -D CMAKE_C_FLAGS="%optflags" CMakeLists.txt
%make_build VERBOSE=1


%install
%makeinstall_std

install -pm 644 -D %{SOURCE3} %buildroot%_niconsdir/%name.png
install -pm 644 -D %{SOURCE2} %buildroot%_miconsdir/%name.png
install -pm 644 -D res/linux/icons/openxcom_48x48.png %buildroot%_liconsdir/%name.png
install -pm 644 -D res/linux/icons/openxcom_128x128.png %buildroot%_iconsdir/hicolor/128x128/apps/%name.png
install -pm 644 -D res/linux/icons/openxcom.svg %buildroot%_iconsdir/hicolor/scalable/apps/%name.svg
install -pm 644 -D res/linux/openxcom.desktop %buildroot%_desktopdir/%name.desktop

%files
%doc CHANGELOG.txt README.* LICENSE.txt
%_bindir/%name
%_datadir/%name
%_man6dir/%{name}.6*
%_iconsdir/hicolor/*/apps/%name.*
%_desktopdir/%name.desktop

%changelog
