# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%ifarch %e2k ppc64le
%def_disable qtwebengine
%else
%def_enable qtwebengine
%endif

Name:     otter-browser
Version:  1.0.03
Release:  alt1

Summary:  Otter Browser aims to recreate the best aspects of the classic Opera (12.x) UI using Qt5
License:  GPL-3.0
Group:    Other
Url:      https://github.com/OtterBrowser/otter-browser

Packager: Anton Midyukov <antohami@altlinux.org>

Source:   %name-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++ cmake
BuildRequires: pkgconfig(Qt5Core)
BuildRequires: pkgconfig(Qt5DBus)
BuildRequires: pkgconfig(Qt5Gui)
BuildRequires: pkgconfig(Qt5Multimedia)
BuildRequires: pkgconfig(Qt5Network)
BuildRequires: pkgconfig(Qt5PrintSupport)
BuildRequires: pkgconfig(Qt5Qml)
BuildRequires: pkgconfig(Qt5Svg)
BuildRequires: pkgconfig(Qt5XmlPatterns)
%if_enabled qtwebengine
BuildRequires: pkgconfig(Qt5WebEngineWidgets)
%else
BuildRequires: pkgconfig(Qt5WebKit)
%endif
BuildRequires: pkgconfig(Qt5Widgets)
BuildRequires: pkgconfig(hunspell)

%description
%summary

%prep
%setup

%build
%cmake \
%if_enabled qtwebengine
    -DENABLE_QTWEBENGINE:BOOL=ON \
%else
    -DENABLE_QTWEBKIT:BOOL=ON \
%endif
    #
%cmake_build

%install
%cmakeinstall_std

%files
%_bindir/*
%_man1dir/*
%_datadir/%name
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/*/*
%doc CHANGELOG CONTRIBUTING.md COPYING README.md

%changelog
