# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: pachi
Version: 1.0
Release: alt3.qa4

Summary: Cool 2D game like Manic Miner, Jet set Willy and more from the 80s
License: GPLv2
Group: Games/Arcade
Url: http://dragontech.sourceforge.net/
Packager: Slava Semushin <php-coder@altlinux.ru>

BuildRequires: gcc-c++ libSDL-devel libSDL_mixer-devel ImageMagick
Requires: %name-data = %version

# http://prdownloads.sf.net/dragontech/pachi_source.tgz
Source: Pachi.tar.bz2
Patch0: Pachi-makefile-alt.patch
Patch1: pachi-alt-src-off-by-one_fix.patch
Patch2: pachi-alt-warnigs-fix.patch

%description
Pachi el marciano is a cool 2D platforms game inspired in games like
Manic Miner, Jet set Willy and more from the 80s.

%package data
Summary: Data files for Pachi game
Group: Games/Arcade
BuildArch: noarch
Requires: %name = %version

%description data
Architecture-independent data files for Pachi game.

%prep
%setup -n Pachi
%patch0
%patch1
%patch2

%build
%configure --bindir=%_gamesbindir --datadir=%_gamesdatadir
%make_build --silent --no-print-directory CXXFLAGS="%optflags"

%install
%make_install --silent --no-print-directory DESTDIR=%buildroot install

# menu
mkdir -p %buildroot%_desktopdir
cat > %buildroot%_desktopdir/%{name}.desktop <<EOF
[Desktop Entry]
Version=1.0
Type=Application
Name=Pachi
GenericName=
Comment=%{summary}
Icon=%{name}
Exec=%_gamesbindir/%name
#Exec=%name
Terminal=false
Categories=Game;ArcadeGame;
EOF

# icons
convert Tgfx/icon.bmp -resize 16x16 Tgfx/%name-16.png
convert Tgfx/icon.bmp -resize 32x32 Tgfx/%name-32.png
convert Tgfx/icon.bmp -resize 48x48 Tgfx/%name-48.png

install -pD -m644 Tgfx/%name-16.png %buildroot%_miconsdir/%name.png
install -pD -m644 Tgfx/%name-32.png %buildroot%_niconsdir/%name.png
install -pD -m644 Tgfx/%name-48.png %buildroot%_liconsdir/%name.png

%files
%doc AUTHORS ChangeLog
%attr(2711,root,games) %_gamesbindir/%name
%_desktopdir/%{name}.desktop
%_niconsdir/%name.png
%_miconsdir/%name.png
%_liconsdir/%name.png
%_localstatedir/games/%name
%config(noreplace) %attr(664,games,games) %_localstatedir/games/%name/data/scores.dat

%files data
%_gamesdatadir/%name

%changelog
