# git commit d3151bce6c101370087e174d8aadb95261a4adcc

Summary: The New Moon browser, an unofficial branding of the Pale Moon project browser
Summary(ru_RU.UTF-8): Интернет-браузер New Moon - неофициальная сборка браузера Pale Moon

Name: palemoon
Version: 33.7.1

Release: alt1

License: MPL-2.0 GPL-3.0 and LGPL-2.1+
Group: Networking/WWW

Url: https://github.com/MoonchildProductions/Pale-Moon
Vcs: https://github.com/MoonchildProductions/Pale-Moon

Epoch: 2

ExclusiveArch: x86_64 aarch64
# ppc64le

%define sname palemoon
%define bname newmoon

Packager: Hihin Ruslan <ruslandh@altlinux.ru>

%define palemoon_cid                    \{8de7fcbb-c55c-4fbe-bfc5-fc555c87dbc4\}

%define newmoon_prefix                  %_libdir/%bname
#define newmoon_datadir                 %%_datadir/%%sname
%define newmoon_datadir                 %_datadir/%bname
%define newmoon_bindir                  %_libdir/%bname
%define palemoon_arch_extensionsdir     %_newmoon_datadir/extensions
#define palemoon_noarch_extensionsdir   %%newmoon_datadir/extensions

Source: %sname-source-%version-%release.tar

Source1: rpm-build.tar
Source2: defaults-%bname.tar

Source4: %sname-mozconfig
Source6: %bname.desktop
Source7: firefox.c
#Source8: firefox-prefs.js
Source9: HISTORY_GIT
Source10: Changelog
Source11: content.tar

#Source12: xulstore.json
#Source13: kde.js

Patch10: palemoon-33.0.1-compatversion.patch

#Patch15: palemoon-32.0.1-ppc64le-alt1.patch


#Patch1: palemoon_google_add-26.4.0.patch
Patch16: mozilla_palimoon-29.4.6-cross-desctop.patch

Patch18: mozilla_palimoon-33.4.1-bug-1153109-enable-stdcxx-compat.patch

#Patch21: palemoon-build-el5-nss.patch

Patch22: palemoon_rpath-29.4.6.patch

#Patch23: palemoon_version-33.6.0.patch
Patch24: palemoon-31.0.0-ui_picker_false.patch
#Patch25: palemoon-31.3.0.1-lock_impl_posix.patch

# Patch from Rosa
Patch103: palemoon-29.4.6-disable-check-default-browser.patch
Patch105: palemoon-29.4.6-default-mail-handler.patch
Patch106: palemoon-29.4.6-enable-addons.patch
#Patch107: palemoon-29.4.6-user-agent-overrides.patch

# Patches for KDE integration of New Moon
Patch111: palemoon-29.4.6-firefox-kde.patch
Patch112: palemoon-29.4.6-mozilla-kde.patch
Patch113: palemoon-29.4.6-kde-background.patch

Patch115: palemoon-32.4.0-mathops.patch
Patch116: palemoon-32.4.0-hunspell.patch
#Patch117: palemoon-32.5.1-locale.patch

# Patch200: %bname-33.6.0-branding.patch

%set_autoconf_version 2.13

BuildPreReq: gstreamer1.0-devel gst-plugins1.0-devel libpixman-devel
BuildPreReq: python3-base unzip xorg-cf-files libsndfile-devel

# Automatically added by buildreq on Wed Mar 27 2024
# optimized out: alt-os-release alternatives fontconfig-devel glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 libICE-devel libSM-devel libX11-devel libXext-devel libXrender-devel libatk-devel libcairo-devel libcairo-gobject libcairo-gobject-devel libcrypt-devel libctf-nobfd0 libdbus-devel libdbus-glib libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libgpg-error libharfbuzz-devel libpango-devel libstdc++-devel libxcb-devel perl pkg-config python-modules python-modules-compiler python-modules-ctypes python-modules-curses python-modules-distutils python-modules-email python-modules-encodings python-modules-logging python-modules-multiprocessing python-modules-xml python2-base python3 python3-base python3-dev sh5 xorg-proto-devel zlib-devel
BuildRequires: doxygen gcc-c++ libGConf-devel libXt-devel libalsa-devel libdbus-glib-devel libgtk+2-devel
BuildRequires: libgtk+3-devel libhunspell-devel libpulseaudio-devel libsocket
BuildRequires: python-devel python-modules-json python-modules-wsgiref python3-module-setuptools
BuildRequires: unzip yasm zip

# BEGIN SourceDeps(oneline):
BuildRequires: gobject-introspection-devel libssl-devel perl(Archive/Zip.pm) perl(CGI.pm) perl(LWP/Simple.pm)
BuildRequires: perl(XML/LibXML.pm) perl(XML/LibXSLT.pm) perl(diagnostics.pm) perl(fastcwd.pl) swig texinfo
BuildRequires: bzlib-devel gobject-introspection-devel libgtest-devel libpng-devel libssl-devel swig texinfo zlib-devel
# END SourceDeps(oneline)

BuildPreReq: %_bindir/python2.7 python2-base
BuildPreReq: libXcomposite-devel libXdamage-devel

%ifarch x86_64
BuildRequires: libcpuid-devel
%endif

BuildRequires(pre): mozilla-common-devel rpm-macros-alternatives mozilla-common
BuildRequires(pre): browser-plugins-npapi-devel

BuildPreReq: python-module-future python-modules-json python-modules-wsgiref

BuildPreReq: alsa-plugins libx264-devel libsox-devel transfig alsa-oss alsa-tools alsa-utils libogg-devel liboggz-devel xorg-proto-devel
BuildPreReq: gstreamer-devel

# set_gcc_version 4.9
# BuildRequires: gcc%%{_gcc_version}-c++

BuildPreReq: chrpath
BuildPreReq: autoconf_%_autoconf_version

BuildRequires: libhunspell-devel
# BuildRequires: wayland-devel libwaylandpp-devel libwayland-egl-devel libEGL-devel
 
%description
The %sname project is a redesign of Mozilla's  Firefox browser component,
written using the XUL user interface language and designed to be
cross-platform.

%description -l ru_RU.UTF-8
Интернет-браузер %sname - кроссплатформенная модификация браузера Mozilla Firefox ,
созданная с использованием языка XUL для описания интерфейса пользователя.

%package -n %bname
Summary: The New Moon browser, an unofficial branding of the Pale Moon project browser
Summary(ru_RU.UTF-8): Интернет-браузер New Moon - неофициальная сборка браузера Pale Moon
Group: Networking/WWW

Provides: palemoon = %EVR
Provides: webclient

Conflicts: %bname < 31.0.0

# Requires: gst-plugins-bad1.0 
# Requires: gst-plugins-good1.0 
# Requires: gst-plugins-ugly1.0 
# Requires: gst-plugins1.0-tools
# Requires: gstreamer1.0-utils 

# Requires: libgstreamer1.0 gst-libav
# Requires: gst-plugins-base1.0

# Protection against fraudulent DigiNotar certificates
# Requires: libnss

%description -n %bname
The New Moon browser, an unofficial branding of the Pale Moon project browser
The %sname project is a redesign of Mozilla's  Firefox browser component,
written using the XUL user interface language and designed to be
cross-platform.

%description -n %bname -l ru_RU.UTF-8
Интернет-браузер New Moon - неофициальная сборка браузера Pale Moon
Интернет-браузер %sname - кроссплатформенная модификация браузера Mozilla Firefox ,
созданная с использованием языка XUL для описания интерфейса пользователя.

%package -n rpm-build-palemoon
Summary: RPM helper macros to rebuild %name packages
Group: Development/Other
BuildArch: noarch

Requires: mozilla-common-devel
Requires: rpm-build-mozilla.org

%description -n rpm-build-palemoon
These helper macros provide possibility to rebuild
%sname packages by some Alt Linux Team Policy compatible way.

%prep
%setup -n %sname-%version -c

#cd UXP-PM%{version}_Release
# patch to move files directly to /usr/lib No more symlinks
pushd platform
sed -e 's;$(libdir)/$(MOZ_APP_NAME)-$(MOZ_APP_VERSION);$(libdir)/$(MOZ_APP_NAME);g' -i config/baseconfig.mk
sed -e 's;$(libdir)/$(MOZ_APP_NAME)-devel-$(MOZ_APP_VERSION);$(libdir)/$(MOZ_APP_NAME)-devel;g' -i config/baseconfig.mk
popd

%setup -T -D -a 2
%setup -T -D -a 11

%patch10 -p1

%patch24 -p1
#patch25 -p1

#patch21 -p1

%patch16 -p1

%patch18 -p1 -b .p18

%patch22 -p1

tar -xf %SOURCE1

##patch23 -p1

#Pach from Rosa
##patch101 -p1 -b .lang
%patch103  -p1 -b .disable-software-update
%patch105  -p1 -b .default-mail-handler
%patch106 -p1 -b .addons
#patch107 -p1 -b .ua

# KDE integration
#patch111 -p1 -b .kdepatch
#patch112 -p1 -b .kdemoz
#patch113 -p1 -b .kdebackground

%patch115 -p1
%patch116 -p1
#patch117 -p1


##patch200 -p1

cd %sname
# icons
for s in 16 22 24 32 48 256; do
	install -D -m 644 \
		../defaults-%bname/default$s.png \
		branding/unofficial/
done

cd -

cat >> confvars.sh <<EOF
MOZ_UPDATER=
MOZ_JAVAXPCOM=
MOZ_EXTENSIONS_DEFAULT=' gio'
MOZ_CHROME_FILE_FORMAT=jar
EOF

echo %version > config/version.txt

rpath="/$(printf %%s '%newmoon_bindir' |tr '[:print:]' '_')"
export LDFLAGS="$LDFLAGS -Wl,-rpath,$rpath"

# for  palemoon_rpath-27.0.2.patch
export RPATH_PATH="$rpath"

# %__subst s~'$(MOZ_APP_NAME)-$(MOZ_APP_VERSION)'~'$(MOZ_APP_NAME)$(MOZ_APP_VERSION)'~g  ./platform/config/baseconfig.mk

%__subst s~'"Moonchild Productions"'~'"Moonchild_Productions"'~g  ./platform/build/application.ini
%__subst s~'"Pale Moon"'~'"Pale_Moon"'~g  ./platform/build/application.ini

cp -f %SOURCE4 .mozconfig

echo "mk_add_options MOZ_OBJDIR=obj-%_arch" >> .mozconfig

# echo "mk_add_options MOZ_MAKE_FLAGS=-j${NPROCS:-4}" >> .mozconfig
echo "mk_add_options MOZ_MAKE_FLAGS=%_smp_mflags" >> .mozconfig

echo "ac_add_options --disable-elf-hack" >> .mozconfig
echo "ac_add_options --enable-alsa" >> .mozconfig 
echo "ac_add_options --enable-pulseaudio" >> .mozconfig
echo "ac_add_options --enable-raw" >> .mozconfig
echo "ac_add_options --enable-ffmpeg" >> .mozconfig
echo "ac_add_options --enable-fmp4" >> .mozconfig

echo "ac_add_options --enable-system-hunspell" >> .mozconfig

echo "ac_add_options --x-libraries=%_libdir/X11" >> .mozconfig
echo "ac_add_options --with-nss-prefix=%_libdir/nss" >> .mozconfig

echo "ac_add_options  --with-system-jpeg" >> .mozconfig
echo "ac_add_options  --with-system-zlib" >> .mozconfig


# echo "ac_add_options  --enable-perf" >> .mozconfig
# echo "ac_add_options  --with-system-ffi" >> .mozconfig

%ifarch x86_64
 echo "ac_add_options --with-arch=x86-64" >> .mozconfig
 echo 'ac_add_options --enable-optimize=" -march=x86-64 -msse2 -mfpmath=sse"' >> .mozconfig
%endif



cat << EOF >> palemoon/app/profile/%sname.js
// -----------  Build Add   ------------------------
pref("browser.EULA.override", true);
pref("app.update.auto", false);
pref("app.update.enabled", false);
pref("app.update.autoInstallEnabled", false);
pref("browser.display.use_system_colors", true);
pref("browser.helperApps.deleteTempFileOnExit", false);
pref("browser.link.open_external", 3);
pref("browser.urlbar.decodeURLsOnCopy", true);
pref("extensions.autoDisableScopes", 3);
pref("ui.allow_platform_file_picker", "false");
pref("media.gstreamer.enabled", true);
user_pref("general.useragent.locale",	"chrome://global/locale/intl.properties");
user_pref("extensions.getAddons.cache.enabled", false);
user_pref("intl.locale.matchOS",  true);
user_pref("general.useragent.locale", "C");
EOF


%build
%add_optflags %optflags_shared

%add_findprov_lib_path %newmoon_prefix

export MOZ_BUILD_APP=%sname

# Mozilla builds with -Wall with exception of a few warnings which show up
# everywhere in the code; so, don't override that.
#
# Disable C++ exceptions since Mozilla code is not exception-safe
#
MOZ_OPT_FLAGS=$(echo $RPM_OPT_FLAGS | \
                sed -e 's/-Wall//' -e 's/-fexceptions/-fno-exceptions/g')

export CFLAGS="$MOZ_OPT_FLAGS"
#export CXXFLAGS="$MOZ_OPT_FLAGS -Wno-error=format-overflow -Wmaybe-uninitialized -Wreorder -fno-rtti -ffunction-sections -fdata-sections -D_GNUC_"
export CXXFLAGS="$MOZ_OPT_FLAGS -Wno-error=format-overflow -Wmaybe-uninitialized -Wreorder -D_GNUC_"

# Add fake RPATH
rpath="/$(printf %%s '%newmoon_bindir' |tr '[:print:]' '_')"
export LDFLAGS="$LDFLAGS -Wl,-rpath,$rpath"

# for  palemoon_rpath-27.0.2.patch
export RPATH_PATH="$rpath"

echo '%newmoon_bindir'
echo "$rpath"

export PREFIX="%prefix"
export LIBDIR="%_libdir"
export LIBIDL_CONFIG=%_bindir/libIDL-config-2
export srcdir="$PWD"
export SHELL=/bin/sh

#./mach build

%__autoconf

MOZ_SMP_FLAGS=%_smp_mflags

TOPSRCDIR=$pwd

%make -f client.mk \
 	MAKENSISU= \
 	STRIP="/bin/true" \
 	MOZ_APP_VERSION=%version \
 	MOZ_MAKE_FLAGS="$MOZ_SMP_FLAGS" \
 	mozappdir=%buildroot%newmoon_bindir \
 	clobber

%make -f client.mk \
 	MAKENSISU= \
 	STRIP="/bin/true" \
 	MOZ_APP_VERSION=%version \
 	MOZ_MAKE_FLAGS="$MOZ_SMP_FLAGS" \
 	mozappdir=%buildroot%newmoon_bindir \
 	build

gcc %optflags \
	-Wall -Wextra \
	-DMOZ_PLUGIN_PATH=\"%browser_plugins_path\" \
	-DMOZ_PROGRAM=\"%newmoon_bindir/%bname-bin\" \
	%SOURCE7 -o %bname

%install
## ? install -D -m644 %%SOURCE12 obj-%_arch/dist/bin/browser/defaults/profile/xulstore.json
# нужен только с патчами KDE
#install -D -m644 %%SOURCE13 obj-%_arch/dist/bin/defaults/pref/kde.js

#cd palemoon
cd obj-%_arch
%makeinstall MOZ_APP_VERSION=%version SHELL=/bin/sh


#makeinstall_std MOZ_APP_VERSION=%version COMSPEC=rpm SHELL=/bin/sh
# MOZILLABUILD SHELL=/bin/sh COMSPEC=rpm

rm -f %buildroot%newmoon_bindir/%bname

mkdir -p \
	%buildroot/%mozilla_arch_extdir/%palemoon_cid \
	%buildroot/%mozilla_noarch_extdir/%palemoon_cid

# icons
for s in 16 32 48; do
	install -D -m 644 \
		../defaults-%bname/default$s.png \
		%buildroot/%_iconsdir/hicolor/${s}x${s}/apps/%bname.png
done

if [ -f %buildroot/%_bindir/%sname ];then
    rm  -f %buildroot/%_bindir/%sname
fi

cd ..

install  %bname  %buildroot/%_bindir/%bname

mkdir -p -- \
	%buildroot/%_rpmmacrosdir

sed \
	-e 's,@palemoon_version@,%version,' \
	-e 's,@palemoon_release@,%release,' \
	 rpm-build/rpm.macros.%sname.standalone > %buildroot/%_rpmmacrosdir/%sname

install -D -m 644 rpm-build/rpm.macros.%sname.standalone  %buildroot/%_rpmmacrosdir/%sname

pushd %buildroot

# Remove devel files
rm -rf -- \
 	%buildroot%_libdir/%bname-devel-%version \
 	%buildroot%_libdir/%bname-devel \
 	%buildroot%_datadir/idl/%bname-%version

# install menu file
install -D -m 644 %SOURCE6 ./%_desktopdir/%bname.desktop
install -d -m 755 %buildroot/%newmoon_bindir/browser/defaults/preferences/




install -m 644 %_builddir/palemoon-%version/defaults-%bname/default48.png %buildroot%newmoon_bindir/browser/chrome/icons/default/PMaboutDialog48.png

set -x

# Add alternatives
mkdir -p ./%_altdir
printf '%_bindir/xbrowser\t%_bindir/%bname\t99\n' >./%_altdir/%bname

# Add real RPATH
(set -x
 	rpath="/$(printf %%s '%newmoon_bindir' |tr '[:print:]' '_')"

 	find \
 		%buildroot/%newmoon_bindir \
 	-type f |
 	while read f; do
 		t="$(readlink -ev "$f")"
 		echo $t
 		file "$t" | grep -Fqs ELF || continue
 		if chrpath -l "$t" | grep -Fqs "PATH=$rpath"; then
 			chrpath -r "%newmoon_bindir" "$t"
 			echo cmp Ok
 		else
 			echo cmp No
 			chrpath -l "$t"
 			echo PATH=$rpath
 			echo
 		fi
 	done
     )




#install -d   %buildroot/%_docdir/%bname-%version/
# Add Doc
install -D -m 644 %SOURCE9  %_builddir/%sname-%version
install -D -m 644 %SOURCE10 %_builddir/%sname-%version
# install -D -m 644 %_builddir/palemoon-%version/AUTHORS %_builddir/%sname-%version
# install -D -m 644 %_builddir/palemoon-%version/LICENSE %_builddir/%sname-%version
# install -D -m 644 %_builddir/palemoon-%version/README.md %_builddir/%sname-%version

# cat > %buildroot/%newmoon_bindir/browser/defaults/preferences/%sname-l10n.js <<EOF
# pref("general.useragent.locale",	"chrome://global/locale/intl.properties");
# pref("extensions.getAddons.cache.enabled", false);
# pref("general.useragent.locale", "en-GB");
# EOF




%files -n %bname
%dir %newmoon_bindir
%newmoon_bindir/

%_desktopdir/%bname.desktop
%_miconsdir/%bname.png
%_niconsdir/%bname.png
%_liconsdir/%bname.png

%doc AUTHORS LICENSE HISTORY_GIT Changelog README.md
%_altdir/%bname
%_bindir/%bname

%mozilla_arch_extdir/%palemoon_cid
%mozilla_noarch_extdir/%palemoon_cid

%files -n rpm-build-%sname
%_rpmmacrosdir/%sname
%exclude %_includedir/*

%changelog
