Name:    pascalabcnet
Version: 3.9.0.3372
Release: alt1

Summary: PascalABC.NET programming language  
License: LGPL-3.0
Group:   Development/Other
Url:     http://pascalabc.net/
# VCS: https://github.com/pascalabcnet/pascalabcnet

Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar
Source1: PascalABCNETLinux.desktop
Source2: icons.tar
Source3: PascalABCNETLinux.appdata.xml

ExcludeArch: ppc64le

BuildRequires(pre): rpm-build-mono
BuildRequires: mono-devel
BuildRequires: mono-locale-extras

Requires: mono-devel
Requires: mono-locale-extras

%filter_from_requires /mono(\(PresentationCore\|PresentationFramework\))/d

%description
PascalABC.NET is a Pascal programming language that implements classic Pascal,
most Delphi language features, as well as a number of their own extensions. It
is implemented on the .NET Framework platform and contains all the modern
language features: classes, operator overloading, interfaces, exception
handling, generic classes and routines, garbage collection, lambda expressions,
parallel programming tools.

%prep
%setup
# Use xbuild insead of msbuild
subst 's/msbuild/xbuild/;/^if/,$d' _RebuildReleaseAndRunTests.sh
# Remove proprietary part
rm -rf bin/PT4
# Remove all binaries
find . -name \*.exe -delete
# TODO remove bundled libraries
#find . -name \*.dll -delete
rm -f bin/*.dll
tar xf %SOURCE2

%build
# Build compiler
sh -x _RebuildReleaseAndRunTests.sh
# Build IDE
MONO_IOMAP=case xbuild /p:Configuration=release PascalABCNETLinux.sln

%install
# Install executables and modules
mkdir -p %buildroot%_libexecdir/%name/{Lib,LibSource,Lng,Highlighting,Samples/Graphics}
cp -a bin/*.{exe,dll,chm,config} %buildroot%_libexecdir/%name
cp -a bin/template.pct %buildroot%_libexecdir/%name
cp -a bin/Highlighting/PascalABCNET.xshd %buildroot%_libexecdir/%name/Highlighting
cp -a bin/Lib/*.pcu %buildroot%_libexecdir/%name/Lib
cp -a bin/Lng/* %buildroot%_libexecdir/%name/Lng

# Install sources 
cp -a bin/Lib/*.pas %buildroot%_libexecdir/%name/LibSource

# Install samples
cp -a InstallerSamples/!MainFeatures %buildroot%_libexecdir/%name/Samples
cp -a InstallerSamples/!Tutorial  %buildroot%_libexecdir/%name/Samples
cp -a InstallerSamples/!РусскиеИсполнители %buildroot%_libexecdir/%name/Samples
cp -a InstallerSamples/Algorithms %buildroot%_libexecdir/%name/Samples
cp -a InstallerSamples/Applications %buildroot%_libexecdir/%name/Samples
cp -a InstallerSamples/Games %buildroot%_libexecdir/%name/Samples
cp -a InstallerSamples/LanguageFeatures %buildroot%_libexecdir/%name/Samples
cp -a InstallerSamples/LINQ %buildroot%_libexecdir/%name/Samples
cp -a InstallerSamples/NETLibraries %buildroot%_libexecdir/%name/Samples
cp -a InstallerSamples/Other %buildroot%_libexecdir/%name/Samples
cp -a InstallerSamples/StandardUnits %buildroot%_libexecdir/%name/Samples
cp -a InstallerSamples/WhatsNew %buildroot%_libexecdir/%name/Samples
cp -a InstallerSamples/Graphics/GraphABC %buildroot%_libexecdir/%name/Samples/Graphics

# Install executable wrappers
mkdir -p %buildroot%_bindir

# Executable wrappers
cat > %buildroot%_bindir/pabcnetc << ENDF
#!/bin/bash
export MONO_IOMAP=all
mono %_libexecdir/pascalabcnet/pabcnetc.exe \$@
ENDF
chmod +x %buildroot%_bindir/pabcnetc

cat > %buildroot%_bindir/pabcnetcclear << ENDF
#!/bin/bash
export MONO_IOMAP=all
mono %_libexecdir/pascalabcnet/pabcnetcclear.exe \$@
ENDF
chmod +x %buildroot%_bindir/pabcnetcclear

cat > %buildroot%_bindir/PascalABCNETLinux << ENDF
#!/bin/bash
export MONO_IOMAP=all
export MONO_REGISTRY_PATH=\$HOME/PABCWork.NET
export MONO_HELP_VIEWER=kchmviewer
[ -d "\$MONO_REGISTRY_PATH" ] || mkdir -p "\$MONO_REGISTRY_PATH"
mono %_libexecdir/pascalabcnet/PascalABCNETLinux.exe "\$@"
ENDF
chmod +x %buildroot%_bindir/PascalABCNETLinux

# Install desktop file and icons
install -Dpm0644 %SOURCE1 %buildroot%_desktopdir/PascalABCNETLinux.desktop
pushd icons
for icon in *.png; do
	size="${icon#pascalabcnet-}"
	size="${size%.png}"
	install -Dpm0644 $icon %buildroot%_iconsdir/hicolor/${size}x${size}/apps/pascalabcnet.png
done
popd

# Install appdata.xml
install -Dpm 0644 %SOURCE3 %buildroot%_datadir/metainfo/PascalABCNETLinux.appdata.xml

%files
%doc README.md doc/*
%_bindir/*
%_libexecdir/%name
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/pascalabcnet.png
%_datadir/metainfo/*.appdata.xml

%changelog
