%define _unpackaged_files_terminate_build 1
%define pyagentx_version 0.4.pcs.2

Name: 	       pcs
Epoch:         1
Version:       0.11.6
Release:       alt1
Summary:       Pacemaker/Corosync configuration system
License:       GPL-2.0 and Apache-2.0 and MIT
Group:         System/Servers
Url:           https://github.com/ClusterLabs/pcs
Vcs:           https://github.com/ClusterLabs/pcs.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
Source1:       pyagentx-v%pyagentx_version.tar.gz
Source2:       pcsd
Source3:       known-hosts
Source4:       pcsd.gemspec
Patch:         compat.patch
Patch1:        disable-ruby-build.patch

%add_python3_req_skip pyagentx
Requires:      python3-module-pcs = %version
Requires:      python3-module-snmp = %version
Obsoletes:     pcs-pcsd < %EVR
Provides:      pcs-pcsd = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-ruby
BuildRequires: corosync fontconfig fonts-ttf-liberation
BuildRequires: libpacemaker-devel
BuildRequires: libsystemd-devel
BuildRequires: wget
BuildRequires: service
BuildRequires: nss-utils
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-lxml
BuildRequires: python3-module-pip
BuildRequires: python3-module-setuptools_scm
BuildRequires: python3-module-pycurl
BuildRequires: python3-module-pyparsing
BuildRequires: python3-module-dacite
BuildRequires: python3-module-tornado >= 6.0.0
BuildRequires: python3-module-dateutil
BuildRequires: python3-module-distro
BuildRequires: python3-module-wheel

%ruby_alias_names pcsd,pcs

%description
Pacemaker/Corosync configuration system with remote access
Pacemaker/Corosync gui/cli configuration system and daemon

%package       -n python3-module-pcs
Summary:       Python module for pacemaker/corosync gui/cli configuration system and daemon
Group:         Development/Python3
BuildArch:     noarch
Requires:      %name = %version
Requires:      pacemaker >= 2.0.3-alt2

%description   -n python3-module-pcs
Python module for pacemaker/corosync gui/cli configuration system and daemon

%package       -n python3-module-snmp
Group:         Development/Python3
Summary:       Pacemaker cluster SNMP agent
License:       GPL-2.0 or BSD-2-Clause
Requires:      %name = %EVR
Requires:      pacemaker >= 2.0.3-alt2
Requires:      net-snmp
Obsoletes:     pcs-snmp < %EVR
Provides:      pcs-snmp = %EVR

%description   -n python3-module-snmp
SNMP agent that provides information about pacemaker cluster to the master
agent (snmpd).

%prep
%setup
%autopatch
cp %SOURCE1 rpm
mkdir -p pcs_bundled/src
echo %version > .tarball-version
echo %version > .version
cp %SOURCE4 pcsd/

%build
%autoreconf
export PATH=/sbin:$PATH
%configure \
    --with-distro=fedora \
    --localstatedir=%_var \
    --enable-local-build \
    --enable-use-local-cache-only \
    --enable-individual-bundling \
    PYTHON=%__python3 \
    ENABLE_DOWNLOAD=false \
    INSTALL_EMBEDDED_GEMS=false \
    SYSTEMCTL="/bin/systemctl"
%make_build
%ruby_build --join=bin:lib


%install
%makeinstall_std \
     LOCAL_BUILD=false \
     ENABLE_DOWNLOAD=false \
     SYSTEMCTL_OVERRIDE=true \
     DEST_SYSTEMD_SYSTEM=%buildroot%systemd_unitdir \
     bashcompletiondir=%_sysconfdir/bash_completion.d

install -Dm 0755 %SOURCE2 %buildroot%_initdir/pcsd
install -Dm 0644 %SOURCE3 %buildroot%_localstatedir/pcsd/known-hosts

# Set correct python3 executable in shebang
subst 's|#!.*python$|#!%__python3|' %buildroot%_libdir/pcs/pcs_bundled/packages/pyagentx/*.py

# Remove wrong placed documentation
rm -f %buildroot%_defaultdocdir/pcs/*.md

%check
%ruby_test

%post
%post_service pcsd

%preun
%preun_service pcsd

%post -n python3-module-snmp
%post_service pcs_snmp_agent

%preun -n python3-module-snmp
%preun_service pcs_snmp_agent

%files
%doc CHANGELOG.md COPYING README.md
%_sbindir/pcs
%_man8dir/*.*
%exclude %_man8dir/pcs_snmp_agent.*
%_sysconfdir/bash_completion.d/pcs
%_sbindir/pcsd
%_initdir/pcsd
%_libdir/pcsd
%dir %_libdir/pcs
%dir %_libdir/pcs/pcs_bundled
%dir %_libdir/pcs/pcs_bundled/packages/
%_libdir/pcs/pcs_internal
%_libdir/pcs/data
%config(noreplace) %_sysconfdir/pam.d/pcsd
%config(noreplace) %_sysconfdir/sysconfig/pcsd
%config(noreplace) %_logrotatedir/pcsd
%dir %_logdir/pcsd
%dir %_localstatedir/pcsd
%systemd_unitdir/pcsd.service
%systemd_unitdir/pcsd-ruby.service
%_localstatedir/pcsd/known-hosts

%files -n python3-module-pcs
%python3_sitelibdir_noarch/*

%files -n python3-module-snmp
%config(noreplace) %_sysconfdir/sysconfig/pcs_snmp_agent
%_libdir/pcs/pcs_snmp_agent
%_libdir/pcs/pcs_bundled/packages/pyagentx*
%systemd_unitdir/pcs_snmp_agent.service
%_datadir/snmp/mibs/PCMK-PCS*-MIB.txt
%_man8dir/pcs_snmp_agent.*

%changelog
