Name: pcsc-lite-ccid
Version: 1.5.2
Release: alt1

Summary: USB CCID IFD Handler
License: LGPL-2.1
Group: System/Libraries
URL: https://ccid.apdu.fr

Requires: pcsc-lite

Source: %name-%version.tar
Source1: submodules.tar
Patch1: ccid-disable-examples-build.patch

BuildRequires: flex libpcsclite-devel libusb-devel
BuildRequires: autoconf-archive

Provides: ccid = %version-%release
Obsoletes: ccid < %version-%release
Conflicts: pcsc-lite-openct

%define ifddir %(pkg-config libpcsclite --variable=usbdropdir)

%description
This package provides generic USB CCID (Chip/Smart Card Interface
Devices) driver for PC/SC Lite.

%prep
%setup
# Do not build examples requires contrib from external repository
%patch1 -p1
cp README.md README
# Extract submodules
tar xf %SOURCE1

%build
%autoreconf
%configure --enable-twinserial
%make_build

%install
%makeinstall_std
mkdir -p %buildroot/lib/udev/rules.d/
cp -a src/92_pcscd_ccid.rules %buildroot/lib/udev/rules.d/

%files
%doc contrib/Kobil_mIDentity_switch/README_Kobil_mIDentity_switch.txt
%doc AUTHORS README.md NEWS SCARDGETATTRIB.md SCARDCONTOL.md
%config(noreplace) %_sysconfdir/reader.conf.d/libccidtwin
%ifddir/ifd-ccid.bundle
%_libdir/pcsc/drivers/serial/libccidtwin.so
/lib/udev/rules.d/92_pcscd_ccid.rules

%changelog
