%define _unpackaged_files_terminate_build 1
%define dist Encode
Name: perl-%dist
Version: 3.10
Release: alt1

Summary: Character encodings
License: GPL or Artistic
Group: Development/Perl

URL: %CPAN %dist
Source: %dist-%version.tar
Patch: %name-%version-%release.patch

# Automatically added by buildreq on Thu Oct 06 2011
BuildRequires: perl-Filter perl-devel perl-unicore perl-parent

%description
The Encode module provides the interfaces between Perl's strings
and the rest of the system.  Perl strings are sequences of characters.
See "perldoc Encode" for the rest of the story.

%package devel
Summary: Perl Encode Module Generator
Group: Development/Perl
Requires: %name = %version-%release
%description devel
enc2xs builds a Perl extension for use by Encode from either Unicode
Character Mapping files (.ucm) or Tcl Encoding Files (.enc).  Besides
being used internally during the build process of the Encode module,
you can use enc2xs to add your own encoding to Perl.

%package CN
Summary: China-based Chinese Encodings
Group: Development/Perl
Requires: %name = %version-%release
%description CN
The Encode::CN module implements China-based Chinese charset encodings.
The following encodings are supported: euc-cn, gb2312-raw, gb12345-raw,
iso-ir-165, MacChineseSimp, cp936, hz.

%package TW
Summary: Taiwan-based Chinese Encodings
Group: Development/Perl
Requires: %name = %version-%release
%description TW
The Encode::TW module implements tradition Chinese charset encodings
as used in Taiwan and Hong Kong.  The following encodings are supported:
big5-eten, big5-hkscs, MacChineseTrad, cp950.

%package KR
Summary: Korean Encodings
Group: Development/Perl
Requires: %name = %version-%release
%description KR
The Encode::KR module implements Korean charset encodings.
The following encodings are supported: euc-kr, ksc5601-raw, cp949,
MacKorean, johab, iso-2022-kr.

%package JP
Summary: Japanese Encodings
Group: Development/Perl
Requires: %name = %version-%release
%description JP
The Encode::JP module implements Japanese charset encodings.
The following encodings are supported: euc-jp, shiftjis, 7bit-jis,
iso-2022-jp, iso-2022-jp-1, MacJapanese, cp932, jis0201-raw,
jis0208-raw, jis0212-raw.

%prep
%setup -q -n %dist-%version
%patch -p1
bzip2 -k Changes

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc	AUTHORS README Changes
	%_bindir/piconv
	%_bindir/encguess
	%perl_vendor_archlib/encoding.pm
	%perl_vendor_archlib/Encode.pm
%dir	%perl_vendor_archlib/Encode
	%perl_vendor_archlib/Encode/*.pm
%doc	%perl_vendor_archlib/Encode/*.pod
%dir	%perl_vendor_archlib/Encode/MIME
	%perl_vendor_archlib/Encode/MIME/*.pm
	%perl_vendor_archlib/Encode/Unicode
	%perl_vendor_autolib/Encode
%exclude %perl_vendor_archlib/Encode/CN*
%exclude %perl_vendor_autolib/Encode/CN*
%exclude %perl_vendor_archlib/Encode/TW*
%exclude %perl_vendor_autolib/Encode/TW*
%exclude %perl_vendor_archlib/Encode/KR*
%exclude %perl_vendor_autolib/Encode/KR*
%exclude %perl_vendor_archlib/Encode/JP*
%exclude %perl_vendor_autolib/Encode/JP*

%files devel
	%_bindir/enc2xs
%dir	%perl_vendor_archlib/Encode
	%perl_vendor_archlib/Encode/*.e2x
	%perl_vendor_archlib/Encode/*.h

%files CN
%dir	%perl_vendor_archlib/Encode
	%perl_vendor_archlib/Encode/CN*
%dir	%perl_vendor_autolib/Encode
	%perl_vendor_autolib/Encode/CN*

%files TW
%dir	%perl_vendor_archlib/Encode
	%perl_vendor_archlib/Encode/TW*
%dir	%perl_vendor_autolib/Encode
	%perl_vendor_autolib/Encode/TW*

%files KR
%dir	%perl_vendor_archlib/Encode
	%perl_vendor_archlib/Encode/KR*
%dir	%perl_vendor_autolib/Encode
	%perl_vendor_autolib/Encode/KR*

%files JP
%dir	%perl_vendor_archlib/Encode
	%perl_vendor_archlib/Encode/JP*
%dir	%perl_vendor_autolib/Encode
	%perl_vendor_autolib/Encode/JP*
%dir	%perl_vendor_archlib/Encode/MIME
%dir	%perl_vendor_archlib/Encode/MIME/Header
	%perl_vendor_archlib/Encode/MIME/Header/ISO_2022_JP.pm

%changelog
