%define _unpackaged_files_terminate_build 1
%define module Spreadsheet-WriteExcel

Name: perl-%module
Version: 2.40
Release: alt1

Packager: Victor Forsiuk <force@altlinux.org>

Summary: Perl module for generating Excel97+ compatible Spreadsheets
License: Perl
Group: Development/Perl

URL: %CPAN %module
Source: http://www.cpan.org/authors/id/J/JM/JMCNAMARA/Spreadsheet-WriteExcel-%{version}.tar.gz

BuildArch: noarch

# Automatically added by buildreq on Mon Nov 30 2009
BuildRequires: perl-Digest-MD4 perl-Encode perl-OLE-Storage_Lite perl-Parse-RecDescent perl-devel

# About perl-Digest-MD4 run-time dependancy:
# The Spreadsheet::WriteExcel module checks in run-time for modules available
# to calculate image checksum. Excel uses MD4 but MD5 will also work.
# In the event of no checksum module being available checksum is simulated
# using the image index. perl-Digest-MD4 selected as best choice:
# real checksum, fast implementation, Excel compatibility.

Requires: perl-Digest-MD4

Obsoletes: perl-%{module}2
Provides: perl-%{module}2

# automatically added during perl 5.8 -> 5.12 upgrade.
# perl-podlators is required for pod2man conversion.
BuildRequires: perl-podlators

%description
The Spreadsheet::WriteExcel module can be used to create a cross-platform
Excel binary file. Multiple worksheets can be added to a workbook and
formatting can be applied to cells. Text, numbers, formulas, hyperlinks and
images can be written to the cells.

The Excel file produced by this module is compatible with Excel 97, 2000, 2002
and 2003. Unicode data is fully supported so generated files can be used in
OpenOffice.org Calc and Gnumeric w/o any additional converters even if
non-Latin1 strings are in use. The generated files are compatible with MS
Access as well.

%prep
%setup -n %module-%version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%_bindir/*
%perl_vendor_privlib/Spreadsheet
%_man1dir/*
%doc README Changes examples docs/*

%changelog
