%define _unpackaged_files_terminate_build 1
%define dist XML-LibXML
%def_without bootstrap
Name: perl-%dist
Version: 2.0207
Release: alt4

Summary: Perl binding for libxml2
License: GPL or Artistic
Group: Development/Perl

URL: %CPAN %dist
Source0: http://www.cpan.org/authors/id/S/SH/SHLOMIF/%{dist}-%{version}.tar.gz
Patch: XML-LibXML-2.0207-alt-at-autoreq.patch

Provides: perl-XML-LibXML-Common = 0.13-alt99
Obsoletes: perl-XML-LibXML-Common < 0.13-alt99
# Since the version of libxml2 is embedded into
# XML::LibXML::LIBXML_VERSION() at build time, this package
# has to be rebuilt every time the version of libxml2 is changed.
Requires: %(rpmquery --qf '%%{NAME} = %%{VERSION}' libxml2)

# Automatically added by buildreq on Fri Oct 07 2011
BuildRequires: libxml2-devel perl-Devel-CheckLib perl-Test-Differences perl-Test-Pod perl-URI perl-XML-NamespaceSupport
BuildRequires: perl-Alien-Libxml2

%if_with bootstrap
BuildRequires: perl-XML-SAX-Base
%define _without_test 1
%else
BuildRequires: perl-XML-SAX
%endif

%description
This module is an interface to the Gnome libxml2 DOM and SAX parser and
the DOM tree.  It also provides an XML::XPath-like findnodes() interface,
providing access to the XPath API in libxml2.

%prep
%setup -q -n %{dist}-%{version}
%patch -p1

%if_with bootstrap
# bootstrap: disable build dependency on XML::SAX
mv t/14sax.t t/14sax.t.orig
mv t/48_SAX_Builder_rt_91433.t t/48_SAX_Builder_rt_91433.t.orig
%endif

%build
%perl_vendor_build INC=-I/usr/include/libxml2 LIBS=-lxml2

%install
%perl_vendor_install

%files
%doc	Changes README HACKING.txt docs example
%dir	%perl_vendor_archlib/XML
	%perl_vendor_archlib/XML/LibXML.pm
%doc	%perl_vendor_archlib/XML/LibXML.pod
%dir	%perl_vendor_archlib/XML/LibXML
	%perl_vendor_archlib/XML/LibXML/*.pm
%doc	%perl_vendor_archlib/XML/LibXML/*.pod
%dir	%perl_vendor_archlib/XML/LibXML/SAX
	%perl_vendor_archlib/XML/LibXML/SAX/*.pm
%doc	%perl_vendor_archlib/XML/LibXML/SAX/*.pod
	%perl_vendor_autolib/XML

%changelog
