%define _unpackaged_files_terminate_build 1

%define lib_name libpfs
%def_without octave
%def_without opencv

Name: pfstools
Version: 2.2.0
Release: alt2

Summary: High Dynamic Range (HDR) Images and Video manipulation tools
License: GPLv2+
Group: Graphics

Url: http://pfstools.sourceforge.net/
Source: %name-%version.tar
Patch0: %name-2.1.0-gcc8-fix.patch
Patch1: %name-2.2.0-alt-build.patch

BuildRequires: gcc-c++ libImageMagick-devel libfftw3-devel libGLUT-devel libgeos-devel
BuildRequires: libjpeg-devel liblapack-devel libncurses-devel libnetpbm-devel
BuildRequires: libreadline-devel openexr-devel cmake libgsl-devel libexif-devel
BuildRequires: libgomp-devel libtbb-devel zlib-devel
BuildRequires: rpm-build-python3

%if_with opencv
BuildRequires: libopencv-devel-static
%endif

%if_with octave
BuildRequires: octave-devel
%endif

# Optimized out build requirements we want to add as safety belt
# (so pfstools build will not fail if due to changes in other packages
# deps listed below packages will not be pulled for build)
BuildRequires: qt5-base-devel libtiff-devel
BuildRequires: gcc-fortran
BuildRequires(pre): rpm-macros-cmake

Requires: %lib_name = %EVR

# TODO: Move pfsglview and pfsview to own packages to prevent users from
# having to install OpenGL/GLUT and Qt?

%description
pfstools package is a set of command line (and one GUI) programs for reading,
writing, manipulating and viewing high-dynamic range (HDR) images and video
frames. All programs in the package exchange data using a simple generic file
format (pfs) for HDR data. The concept of the pfstools is similar to netpbm
package for low-dynamic range images.

%package -n %lib_name
Summary: Library for %name
Group: System/Libraries
License: LGPLv2.1+

%description -n %lib_name
This package contain the library needed to run programs linked with %lib_name.

%package -n %lib_name-devel
Summary: Headers for developing programs that will use %lib_name
Group: Development/C++
License: LGPLv2.1+
Requires: %lib_name = %EVR

%description -n %lib_name-devel
This package contains the headers that programmers will need to develop

%if_with octave
%package octave
Summary: Octave interaction with PFS tools
Group: Graphics

%description octave
The pfstools-octave package contains programs to process red, green and blue
channels or luminance channels in pfs stream using Octave.
%endif

%prep
%setup
%patch0 -p1
%patch1 -p2

%build
%cmake \
	-DBUILD_SHARED_LIBS=ON
%cmake_build

%install
%cmakeinstall_std

%files
%_bindir/pfsabsolute
%if_with opencv
%_bindir/pfsalign
%endif
%_bindir/pfs_automerge
%_bindir/pfscolortransform
%_bindir/pfshdrcalibrate
%_bindir/pfsinhdrgen
%_bindir/pfsinme
%_bindir/pfsplotresponse
%_bindir/pfsretime
%_bindir/pfstmo_drago03
%_bindir/pfstmo_durand02
%_bindir/pfstmo_fattal02
%_bindir/pfstmo_ferradans11
%_bindir/pfstmo_mai11
%_bindir/pfstmo_mantiuk06
%_bindir/pfstmo_mantiuk08
%_bindir/pfstmo_pattanaik00
%_bindir/pfstmo_reinhard02
%_bindir/pfstmo_reinhard05
%_bindir/pfscat
%_bindir/pfsclamp
%_bindir/pfscut
%_bindir/pfsextractchannels
%_bindir/pfsdisplayfunction
%_bindir/pfsflip
%_bindir/pfsgamma
%_bindir/pfsin
%_bindir/pfsindcraw
%_bindir/pfsinpfm
%_bindir/pfsinppm
%_bindir/pfsinrgbe
%_bindir/pfsintiff
%_bindir/pfsout
%_bindir/pfsouthdrhtml
%_bindir/pfsoutpfm
%_bindir/pfsoutppm
%_bindir/pfsoutrgbe
%_bindir/pfsouttiff
%_bindir/pfs_split_exposures.py
%_bindir/pfspad
%_bindir/pfspanoramic
%_bindir/pfsrotate
%_bindir/pfssize
%_bindir/pfstag
%_bindir/dcraw2hdrgen
%_bindir/pfsinexr
%_bindir/pfsoutexr
%_bindir/pfsinimgmagick
%_bindir/pfsoutimgmagick
%_bindir/pfsglview
%_bindir/pfsview
%_bindir/pfsv
%_bindir/jpeg2hdrgen

%_bindir/pfsinyuv
%_bindir/pfsoutyuv

%_datadir/pfstools

%_man1dir/pfsabsolute.*
%if_with opencv
%_man1dir/pfsalign.*
%endif
%_man1dir/pfs_automerge.*
%_man1dir/pfscolortransform.*
%_man1dir/pfshdrcalibrate.*
%_man1dir/pfsinhdrgen.*
%_man1dir/pfsinme.*
%_man1dir/pfsplotresponse.*
%_man1dir/pfsretime.*
%_man1dir/pfstmo_drago03.*
%_man1dir/pfstmo_durand02.*
%_man1dir/pfstmo_fattal02.*
%_man1dir/pfstmo_ferradans11.*
%_man1dir/pfstmo_mai11.*
%_man1dir/pfstmo_mantiuk06.*
%_man1dir/pfstmo_mantiuk08.*
%_man1dir/pfstmo_pattanaik00.*
%_man1dir/pfstmo_reinhard02.*
%_man1dir/pfstmo_reinhard05.*
%_man1dir/pfscat.*
%_man1dir/pfsclamp.*
%_man1dir/pfscut.*
%_man1dir/pfsdisplayfunction.*
%_man1dir/pfsextractchannels.*
%_man1dir/pfsflip.*
%_man1dir/pfsgamma.*
%_man1dir/pfsin.*
%_man1dir/pfsindcraw.*
%_man1dir/pfsinpfm.*
%_man1dir/pfsinppm.*
%_man1dir/pfsinrgbe.*
%_man1dir/pfsintiff.*
%_man1dir/pfsout.*
%_man1dir/pfsouthdrhtml.*
%_man1dir/pfsoutpfm.*
%_man1dir/pfsoutppm.*
%_man1dir/pfsoutrgbe.*
%_man1dir/pfsouttiff.*
%_man1dir/pfspad.*
%_man1dir/pfspanoramic.*
%_man1dir/pfsrotate.*
%_man1dir/pfssize.*
%_man1dir/pfstag.*
%_man1dir/dcraw2hdrgen.*
%_man1dir/jpeg2hdrgen.*
%_man1dir/pfsinexr.*
%_man1dir/pfsoutexr.*
%_man1dir/pfsinimgmagick.*
%_man1dir/pfsoutimgmagick.*

%_man1dir/pfsglview.*
%_man1dir/pfsview.*

%_man1dir/pfsinyuv.*
%_man1dir/pfsoutyuv.*

%files -n %lib_name
%_libdir/*.so.*

%files -n %lib_name-devel
%_includedir/pfs
%_libdir/pkgconfig/*.pc
%_libdir/*.so

%if_with octave
%files octave
%_bindir/pfsoctavelum
%_bindir/pfsoctavergb
%_bindir/pfsstat
%_libdir/octave/*/site/oct/*/pfstools
%_datadir/octave/*/site/m/pfstools
%_man1dir/pfsoctavelum.*
%_man1dir/pfsoctavergb.*
%_man1dir/pfsstat.*
%endif

%changelog
