%define __find		/bin/find
%define __xargs		/bin/xargs

%def_enable databasedesigner

Name: pgadmin3
Version: 1.22.2
Release: alt4

Summary: Powerful administration and development platform for PostgreSQL.
License: BSD
Group: Databases
Packager: PostgreSQL Maintainers Team <pgsql@packages.altlinux.org>

Url: http://www.pgadmin.org/

Source: %name-%version.tar
Patch: %name-%version.patch

Requires: %name-docs-en_US

BuildRequires: gcc-c++ libxslt-devel postgresql-devel
BuildRequires: libwxGTK-contrib-ogl-devel libwxGTK-contrib-stc-devel libwxGTK-devel
BuildRequires: findutils ImageMagick-tools
BuildRequires: python-module-sphinx
BuildRequires: libssl-devel
BuildRequires: libkrb5-devel
BuildRequires: libssh2-devel

%description
pgAdmin III is a powerful administration and development platform for
the PostgreSQL database, free for any use.
The application runs under GNU/Linux, FreeBSD and Windows 2000/XP.
pgAdmin III is designed to answer the needs of all users, from writing
simple SQL queries to developing complex databases.
The graphical nterface supports all PostgreSQL features and makes
administration easy. The application also includes a query builder,
an SQL editor, a server-side code editor and much more.

%package docs-en_US
Summary: US english docs for %name
Group: Databases
BuildArch: noarch

%description docs-en_US
US english docs for %name.

%package docs-all
Summary: All docs for %name
Group: Databases
BuildArch: noarch

%description docs-all
All docs for %name.

%prep
%setup -q
%patch -p1

%build
/bin/sh bootstrap
%configure CPPFLAGS="-I./include" \
	%{subst_enable databasedesigner} \
	--with-libssh2

%make_build

%install
%make_install DESTDIR=%buildroot install

rm -rf %buildroot%_datadir/%name/docs/*
# make symlink for en_US docs.
ln -s %_defaultdocdir/%name-docs-en_US-%version/en_US %buildroot%_datadir/%name/docs/
#make symlink for all docs.
ln -s %_defaultdocdir/%name-docs-all-%version/de_DE %buildroot%_datadir/%name/docs/
ln -s %_defaultdocdir/%name-docs-all-%version/es_ES %buildroot%_datadir/%name/docs/
ln -s %_defaultdocdir/%name-docs-all-%version/fr_FR %buildroot%_datadir/%name/docs/
ln -s %_defaultdocdir/%name-docs-all-%version/sl_SI %buildroot%_datadir/%name/docs/

mkdir -p %buildroot%_datadir/applications
cat >| %buildroot%_datadir/applications/%name.desktop << 'EOF'
[Desktop Entry]
Name=pgadmin3
Name[en_CA]=%name
Name[en_GB]=%name
Name[ru]=%name
Comment=administration and development platform for the PostgreSQL.
Comment[en_CA]=administration and development platform for the PostgreSQL.
Comment[en_GB]=administration and development platform for the PostgreSQL.
Comment[ru]=Администрирование и разработка для PostgreSQL.
Exec=%name
Terminal=false
Type=Application
Icon=%name
Categories=Development;Database;
StartupNotify=true
EOF

mkdir -p %buildroot{%_iconsdir,%_miconsdir,%_liconsdir}
cp -f pgadmin/include/images/pgAdmin3-16.png %buildroot%_miconsdir/%name.png
cp -f pgadmin/include/images/pgAdmin3-32.png %buildroot%_iconsdir/%name.png
cp -f pgadmin/include/images/pgAdmin3.png %buildroot%_liconsdir/%name.png

# Move locales to their correct place
mkdir -p %buildroot%_datadir/locale
mv -f %buildroot%_datadir/%name/i18n/??_?? %buildroot%_datadir/locale

%find_lang %name

%files -f %name.lang
%_bindir/%name
%dir %_datadir/%name
%_datadir/%name
%_datadir/applications/%name.desktop
%_iconsdir/%name.png
%_liconsdir/%name.png
%_miconsdir/%name.png
%exclude %_datadir/%name/docs

%files docs-en_US
%doc docs/en_US
%doc %_datadir/%name/docs/en_US

%files docs-all
%doc docs/de_DE
%doc docs/es_ES
%doc docs/fr_FR
%doc docs/sl_SI
%doc %_datadir/%name/docs/de_DE
%doc %_datadir/%name/docs/es_ES
%doc %_datadir/%name/docs/fr_FR
%doc %_datadir/%name/docs/sl_SI

%changelog
