%define		php_extension	openssl

Name:	 	php%_php_suffix-%php_extension
Version:	%php_version
Release:	%php_release

Summary:	OpenSSL module for php
Group:		System/Servers
License:	PHP-3.01

Source1:	php-%php_extension.ini
Source2:	php-%php_extension-params.sh

BuildRequires(pre): rpm-build-php7-version
BuildRequires:	php-devel = %php_version

BuildRequires: libssl-devel pkgconfig
# for tests
BuildRequires: php%_php_suffix /proc

%description
This module uses the functions of OpenSSL for generation and verification 
of signatures and for sealing (encrypting) and opening (decrypting) data. 
OpenSSL offers many features that this module currently doesn't support. 
Some of these may be added in the future.

%prep
%setup -T -c
cp -pr %php_extsrcdir/%php_extension/* .

# simple fix
mv config0.m4 config.m4

%build
phpize

BUILD_HAVE=`echo %php_extension | tr '[:lower:]-' '[:upper:]_'`
%add_optflags -fPIC -L%_libdir
export LDFLAGS=-lphp-%_php_version
%configure \
	--with-%php_extension=%_usr \
	--with-libdir=%_lib \
	#
%php_make

%check
export SKIP_ONLINE_TESTS=1
make test

%install
%php_make_install
install -D -m 644 %SOURCE1 %buildroot/%php_extconf/%php_extension/config
install -D -m 644 %SOURCE2 %buildroot/%php_extconf/%php_extension/params

%files
%php_extconf/%php_extension
%php_extdir/*
%doc CREDITS

%post
%php_extension_postin

%preun
%php_extension_preun

%changelog
