%def_disable libcap
%def_enable qt5
%def_disable qt4
%def_disable fltk

Name: pinentry
Version: 1.2.1
Release: alt1

Summary: Simple PIN or passphrase entry dialog
License: GPLv2+
Group: File tools
Url: http://gnupg.org/related_software/pinentry/

Requires: %name-common = %version-%release
%{?_enable_qt4:Requires: %name-qt4 = %version-%release}
Requires: %name-gtk2 = %version-%release

# ftp://ftp.gnupg.org/gcrypt/pinentry/%name-%version.tar.gz
Source: %name-%version.tar
Source1: pinentry-wrapper
# ALT
Patch10: alt-mask-xprop.patch

%if_enabled qt5
BuildRequires: qt5-base-devel kf5-kwayland-devel rpm-build-kf5
%endif
%if_enabled libfltk-devel
BuildRequires: libfltk-devel
%endif
%if_enabled qt4
BuildRequires: libqt4-devel
%endif
%if_enabled libcap
BuildRequires: libcap-devel
%endif
BuildRequires: gcc-c++ libgtk+2-devel libncursesw-devel
BuildRequires: libsecret-devel gcr-libs-devel libassuan-devel
BuildRequires: texinfo

%description
This is simple PIN or passphrase entry dialog which utilize
the Assuan protocol as described by the aegypten project.

%package common
Group: %group
Summary: %summary
Provides: %name = %version-%release
Provides: %name-terminal = %version-%release
Provides: %name-console = %version-%release
Provides: %name-tty = %EVR
Provides: %name-curses = %EVR
Obsoletes: %name-curses < %EVR
Conflicts: pinentry < 0.7.2 pinentry-curses < 0.7.2
Conflicts: pinentry-qt < 0.7.2 pinentry-gtk < 0.7.2

%package gtk2
Group: %group
Summary: %summary
Requires: %name-common = %EVR
Requires: xprop
Provides: %name = %version-%release
Provides: %name-x11 = %version-%release
Provides: pinentry-gtk = %EVR
Obsoletes: pinentry-gtk < %EVR

%package gnome3
Group: %group
Summary: %summary
Requires: %name-common = %EVR
Requires: xprop
Provides: %name = %version-%release
Provides: %name-x11 = %version-%release

%package qt5
Group: %group
Summary: %summary
Requires: xprop
Requires: %name-common = %EVR
Provides: %name = %version-%release
Provides: %name-x11 = %version-%release
Provides: pinentry-qt = %EVR
Obsoletes: pinentry-qt < %EVR

%package qt4
Group: %group
Summary: %summary
Requires: xprop
Requires: %name-common = %EVR
Provides: %name = %version-%release
Provides: %name-x11 = %version-%release

%description gtk2
This is simple PIN or passphrase entry dialog which utilize
the Assuan protocol as described by the aegypten project.
%description gnome3
This is simple PIN or passphrase entry dialog which utilize
the Assuan protocol as described by the aegypten project.
%description qt5
This is simple PIN or passphrase entry dialog which utilize
the Assuan protocol as described by the aegypten project.
%description qt4
This is simple PIN or passphrase entry dialog which utilize
the Assuan protocol as described by the aegypten project.
%description common
This package contains common files and documentation for %name.

%prep
%setup -T -c
tar xf %SOURCE0
mv %name-%version gui

%{?_enable_qt4:cp -a gui gui-qt4}
%{?_enable_qt5:cp -a gui gui-qt5}
cp -a gui tui

install -pm644 %SOURCE1 pinentry-wrapper
%patch10 -p0

for d in tui gui \
             %{?_enable_qt4:gui-qt4} \
             %{?_enable_qt5:gui-qt5} ; do
    pushd $d
    %autoreconf
    popd
done

%build
%add_optflags -std=gnu++11

pushd tui
%configure \
    --disable-rpath \
    --enable-pinentry-curses \
    --enable-pinentry-tty \
    --disable-pinentry-gtk2 \
    --disable-pinentry-fltk \
    --disable-pinentry-gnome3 \
    --disable-pinentry-qt \
    --disable-pinentry-qt5 \
    --disable-libsecret \
    %{?_enable_libcap:--with-libcap}%{!?_enable_libcap:--without-libcap} \
    #
%make_build
popd

pushd gui
%configure \
    --disable-rpath \
    --disable-pinentry-curses \
    --disable-pinentry-tty \
    --enable-pinentry-gtk2 \
    %{?_enable_fltk:--enable-pinentry-fltk} \
    --enable-pinentry-gnome3 \
    --disable-pinentry-qt \
    --disable-pinentry-qt5 \
    --disable-pinentry-qt-clipboard \
    --enable-libsecret \
    %{?_enable_libcap:--with-libcap}%{!?_enable_libcap:--without-libcap} \
    #
%make_build
popd

%if_enabled qt4
pushd gui-qt4
%configure \
    --disable-rpath \
    --disable-pinentry-curses \
    --disable-pinentry-tty \
    --disable-pinentry-gtk2 \
    --disable-pinentry-fltk \
    --disable-pinentry-gnome3 \
    --enable-pinentry-qt4 \
    --disable-pinentry-qt5 \
    --enable-pinentry-qt-clipboard \
    --enable-libsecret \
    %{?_enable_libcap:--with-libcap}%{!?_enable_libcap:--without-libcap} \
    #
%make_build
popd
%endif

%if_enabled qt5
pushd gui-qt5
export KF5WAYLANDCLIENT_LIBS="`pkg-config  --libs KF5WaylandClient` -L%_K5link"
%configure \
    --disable-rpath \
    --disable-pinentry-curses \
    --disable-pinentry-tty \
    --disable-pinentry-gtk2 \
    --disable-pinentry-fltk \
    --disable-pinentry-gnome3 \
    --enable-pinentry-qt \
    --enable-pinentry-qt5 \
    --enable-pinentry-qt-clipboard \
    --enable-libsecret \
    %{?_enable_libcap:--with-libcap}%{!?_enable_libcap:--without-libcap} \
    #
%make_build
popd
%endif

%install
pushd tui
%makeinstall_std
popd
rm %buildroot%_bindir/%name

pushd gui
%makeinstall_std
popd
rm %buildroot%_bindir/%name

%if_enabled qt4
pushd gui-qt4
%makeinstall_std
popd
mv %buildroot/%_bindir/%name-qt %buildroot/%_bindir/%name-qt4
%endif

%if_enabled qt5
pushd gui-qt5
%makeinstall_std
popd
mv %buildroot/%_bindir/%name-qt %buildroot/%_bindir/%name-qt5
%endif

ln -s %name-gtk-2 %buildroot/%_bindir/%name-gtk
%{?_enable_qt5:ln -s %name-qt5 %buildroot/%_bindir/%name-qt}

install -pDm755 pinentry-wrapper %buildroot/%_bindir/pinentry

%files gtk2
%_bindir/%name-gtk
%_bindir/%name-gtk-2

%if_enabled qt4
%files qt4
%_bindir/%name-qt4
%endif

%if_enabled qt5
%files qt5
%_bindir/%name-qt5
%_bindir/%name-qt
%endif

%files gnome3
%_bindir/%name-gnome3

%files common
%doc gui/AUTHORS gui/NEWS gui/README gui/THANKS
%_bindir/%name
%_bindir/%name-curses
%_bindir/%name-tty
%_infodir/*.info*

%changelog
