%def_disable snapshot
%define _unpackaged_files_terminate_build 1

%ifarch armh
%define optflags_lto %nil
%endif

%define _libexecdir %_prefix/libexec
%define ver_major 0.3
%define ms_ver 0.4.2
%define api_ver 0.3
%define spa_api_ver 0.2
%define gst_api_ver 1.0
%define libcamera_ver 1:0.0.1

%def_enable gstreamer
%def_enable systemd
%def_disable wireplumber
%def_enable libusb
%def_enable libcamera
%def_enable avahi
%def_enable webrtc
%def_enable sdl
%def_enable lv2
%def_enable libcanberra
%def_enable lc3
#system service: not recommended and disabled by default
%def_disable systemd_system_service
%def_enable vulkan
%ifarch %e2k
%def_disable examples
%else
%def_enable examples
%endif
%def_disable docs
%def_enable man
%def_enable check

Name: pipewire
Version: %ver_major.71
Release: alt1

Summary: Media Sharing Server
Group: System/Servers
License: MIT
Url: https://pipewire.org/

%if_disabled snapshot
Source: https://github.com/PipeWire/pipewire/archive/%version/%name-%version.tar.gz
%else
Vcs: https://github.com/PipeWire/pipewire.git
Source: %name-%version.tar
%endif
#https://gitlab.freedesktop.org/pipewire/media-session.git
# 0.4.1-15
Source1: media-session-%ms_ver.tar
Patch: %name-0.3.19-alt-rpath.patch

Requires: %name-libs = %version-%release
%{?_enable_wireplumber:Requires: wireplumber}
Requires: rtkit
%{?_enable_gstreamer:%{?_enable_libcamera:Requires: gst-plugins-libcamera1.0}}

%define meson_ver 0.59
%define gst_ver 1.10

BuildRequires(pre): rpm-macros-meson rpm-build-systemd
BuildRequires: meson >= %meson_ver libgio-devel libudev-devel libdbus-devel
BuildRequires: libalsa-devel libpulseaudio-devel
BuildRequires: libjack-devel
BuildRequires: libv4l-devel libsamplerate-devel libsndfile-devel
BuildRequires: libavformat-devel libavcodec-devel libavfilter-devel
BuildRequires: libbluez-devel
BuildRequires: libmysofa-devel
# BT codecs
BuildRequires: libsbc-devel libfdk-aac-devel libldac-devel
BuildRequires: libfreeaptx-devel libopus-devel
%{?_enable_lc3:BuildRequires: liblc3-devel}
# LC3plus BT codec
# BuildRequires: lc3plus-devel
# for pw-top
BuildRequires: libncursesw-devel
# for pw-cli
BuildRequires: libreadline-devel
%if_enabled gstreamer
BuildRequires: pkgconfig(gstreamer-%gst_api_ver) >= %gst_ver
BuildRequires: pkgconfig(gstreamer-base-%gst_api_ver)
BuildRequires: pkgconfig(gstreamer-plugins-base-%gst_api_ver)
BuildRequires: pkgconfig(gstreamer-net-%gst_api_ver)
BuildRequires: pkgconfig(gstreamer-allocators-%gst_api_ver)
%endif
%{?_enable_systemd:BuildRequires: pkgconfig(systemd)}
%{?_enable_wireplumber:BuildRequires: libwireplumber-devel}
%{?_enable_vulkan:BuildRequires: libvulkan-devel}
%{?_enable_libusb:BuildRequires: pkgconfig(libusb-1.0)}
%{?_enable_libcamera:BuildRequires: libcamera-devel >= %libcamera_ver libdrm-devel}
%{?_enable_avahi:BuildRequires: pkgconfig(avahi-client)}
%{?_enable_webrtc:BuildRequires: pkgconfig(webrtc-audio-processing)}
%{?_enable_sdl:BuildRequires: libSDL2-devel}
%{?_enable_lv2:BuildRequires: liblilv-devel}
%{?_enable_libcanberra:BuildRequires: libcanberra-devel}
%{?_enable_docs:BuildRequires: doxygen graphviz fonts-otf-adobe-source-sans-pro fonts-ttf-google-droid-sans}
%{?_enable_man:BuildRequires: python3-module-docutils}
%{?_enable_check:BuildRequires: /proc gcc-c++ libcap-devel}

%description
PipeWire is a multimedia server for Linux and other Unix like operating
systems.

%package libs
Summary: Libraries for PipeWire clients
Group: System/Libraries

%description libs
This package contains the runtime libraries for any application that wishes
to interface with a PipeWire media server.

%package libs-devel
Summary: Headers and libraries for PipeWire client development
Group: Development/C
Requires: %name-libs = %version-%release

%description libs-devel
Headers and libraries for developing applications that can communicate with
a PipeWire media server.

%package libs-devel-doc
Summary: PipeWire media server documentation
Group: Documentation
# https://bugzilla.altlinux.org/34101
BuildArch: noarch
Conflicts: %name-libs-devel < %version

%description libs-devel-doc
This package contains documentation for the PipeWire media server.

%package utils
Summary: PipeWire media server utilities
Group: System/Servers
Requires: %name-libs = %version-%release

%description utils
This package contains command line utilities for the PipeWire media server.

%prep
%setup -a1
mv media-session-%ms_ver subprojects/media-session

#echo -e "SHORT_NAMES = YES\nDIRECTORY_GRAPH = NO\n" >> doc/Doxyfile.in
#%%patch

%build
export LIB=%_lib
%meson \
	%{?_enable_docs:-Ddocs=enabled} \
	%{?_disable_man:-Dman=disabled} \
	%{?_enable_gstreamer:-Dgstreamer=enabled} \
	%{?_disable_vulkan:-Dvulkan=disabled} \
	%{?_disable_libusb:-Dlibusb=disabled} \
	%{?_disable_libcamera:-Dlibcamera=disabled} \
	%{?_disable_avahi:-Davahi=disabled} \
	%{?_disable_webrtc:-Decho-cancel-webrtc=disabled} \
	%{?_disable_sdl:-Dsdl=disabled} \
	%{?_disable_lv2:-Dlv2=disabled} \
	%{?_disable_libcanberra:-Dlibcanberra=disabled} \
	%{?_enable_lc3:-Dbluez5-codec-lc3=enabled} \
	%{?_disable_systemd:-Dsystemd=disabled} \
	%{?_enable_systemd_system_service:-Dsystemd-system-service=enabled} \
	%{?_disable_examples:-Dexamples=disabled} \
	-Dsession-managers='media-session'
%nil
%meson_build

%install
%meson_install
mkdir -p %buildroot%_sysconfdir/%name/{media-session.d,filter-chain}
%find_lang %name media-session --output=%name.lang

%check
%__meson_test

%pre
%_sbindir/groupadd -r -f %name 2>/dev/null ||:
%_sbindir/useradd -r -N -g %name -d / \
	-s /dev/null -c "PipeWire System Daemon" %name 2>/dev/null ||:

%files -f %name.lang
%_bindir/%name
%_bindir/pw-jack
%_bindir/%name-aes67
%_bindir/%name-avb
%_bindir/%name-pulse
%_bindir/%name-media-session
%{?_enable_gstreamer:%_libdir/gstreamer-%gst_api_ver/libgst%name.so}
%_sysconfdir/security/limits.d/25-pw-rlimits.conf
%dir %_sysconfdir/%name/
%dir %_sysconfdir/%name/media-session.d
%dir %_sysconfdir/%name/filter-chain
%dir %_datadir/%name
%_datadir/%name/%name.conf
%_datadir/%name/%name-aes67.conf
%_datadir/%name/client.conf
%_datadir/%name/client-rt.conf
%_datadir/%name/jack.conf
%_datadir/%name/minimal.conf
%_datadir/%name/%name-avb.conf
%_datadir/%name/%name-pulse.conf
%_datadir/%name/filter-chain.conf

%dir %_datadir/%name/client-rt.conf.avail
%_datadir/%name/client-rt.conf.avail/20-upmix.conf

%dir %_datadir/%name/client.conf.avail
%_datadir/%name/client.conf.avail/20-upmix.conf

%dir %_datadir/%name/%name-pulse.conf.avail
%_datadir/%name/%name-pulse.conf.avail/20-upmix.conf

%dir %_datadir/%name/%{name}.conf.avail
%_datadir/%name/%{name}.conf.avail/10-rates.conf
%_datadir/%name/%{name}.conf.avail/20-upmix.conf

%dir %_datadir/%name/media-session.d
%_datadir/%name/media-session.d/alsa-monitor.conf
%_datadir/%name/media-session.d/bluez-monitor.conf
%_datadir/%name/media-session.d/media-session.conf
%_datadir/%name/media-session.d/v4l2-monitor.conf
%_datadir/%name/media-session.d/with-jack
%_datadir/%name/media-session.d/with-pulseaudio
%dir %_datadir/%name/filter-chain
%_datadir/%name/filter-chain/demonic.conf
%_datadir/%name/filter-chain/sink-dolby-surround.conf
%_datadir/%name/filter-chain/sink-eq6.conf
%_datadir/%name/filter-chain/sink-make-LFE.conf
%_datadir/%name/filter-chain/sink-matrix-spatialiser.conf
%_datadir/%name/filter-chain/sink-mix-FL-FR.conf
%_datadir/%name/filter-chain/sink-virtual-surround-5.1-kemar.conf
%_datadir/%name/filter-chain/sink-virtual-surround-7.1-hesuvi.conf
%_datadir/%name/filter-chain/source-rnnoise.conf
%_datadir/%name/filter-chain/source-duplicate-FL.conf

%dir %_datadir/spa-%spa_api_ver
%dir %_datadir/spa-%spa_api_ver/bluez5
%_datadir/spa-%spa_api_ver/bluez5/bluez-hardware.conf

%_udevrulesdir/90-%name-alsa.rules
%_datadir/alsa-card-profile/
%if_enabled systemd
%_userunitdir/%name.service
%_userunitdir/%name.socket
%_userunitdir/%name-pulse.service
%_userunitdir/%name-pulse.socket
%_userunitdir/%name-media-session.service
%_userunitdir/filter-chain.service

%{?_enable_systemd_system_service:
%_unitdir/%name.service
%_unitdir/%name.socket}
%endif
%_datadir/alsa/alsa.conf.d/50-pipewire.conf
%_datadir/alsa/alsa.conf.d/99-pipewire-default.conf
%if_enabled man
%_man1dir/%name.1*
%_man1dir/%name-pulse.1*
%_man1dir/pw-jack.1*
%_man5dir/%name.conf.5*
%endif
%doc README* NEWS

%files libs
%_libdir/lib%name-%api_ver.so.*
%_libdir/%name-%api_ver/
%_libdir/spa-%spa_api_ver/
%_libdir/alsa-lib/

%files libs-devel
%_libdir/lib%name-%api_ver.so
%_includedir/%name-%api_ver/
%_includedir/spa-%spa_api_ver/
%_pkgconfigdir/lib%name-%api_ver.pc
%_pkgconfigdir/libspa-%spa_api_ver.pc

%if_enabled docs
%files libs-devel-doc
%dir %_datadir/doc/%name
%_datadir/doc/%name/html/
%endif

%files utils
%_bindir/pw-cat
%_bindir/pw-cli
%_bindir/pw-config
%_bindir/pw-dot
%_bindir/pw-dsdplay
%_bindir/pw-dump
%_bindir/pw-encplay
%_bindir/pw-link
%_bindir/pw-loopback
%_bindir/pw-metadata
%_bindir/pw-mididump
%_bindir/pw-midiplay
%_bindir/pw-midirecord
%_bindir/pw-mon
%_bindir/pw-play
%_bindir/pw-profiler
%_bindir/pw-record
%_bindir/pw-top
%_bindir/pw-v4l2
%_bindir/pw-reserve
%_bindir/spa-inspect
%_bindir/spa-json-dump
%_bindir/spa-monitor
%_bindir/spa-resample
%_bindir/spa-acp-tool
%if_enabled man
%_man1dir/pw-cat.1.*
%_man1dir/pw-cli.1*
%_man1dir/pw-config.1*
%_man1dir/pw-dot.1.*
%_man1dir/pw-link.1.*
%_man1dir/pw-metadata.1.*
%_man1dir/pw-mididump.1.*
%_man1dir/pw-mon.1*
%_man1dir/pw-profiler.1.*
%_man1dir/pw-top.1.*
%endif


%changelog
