%define rname kscreen

%ifndef _unitdir_user
%define _unitdir_user %prefix/lib/systemd/user
%endif

Name: plasma5-%rname
Version: 5.27.11
Release: alt3
Epoch: 1
%K5init

Group: Graphical desktop/KDE
Summary: KDE Workspace 5 Display Management software
Url: http://www.kde.org
License: GPL-2.0-or-later

Requires: xrandr iio-sensor-proxy
Requires: plasma5-libkscreen-utils
Provides: kf5-kscreen = %EVR
Obsoletes: kf5-kscreen < %EVR

Source: %rname-%version.tar
Source10: kcm_kscreen-ru-add.po
Source11: kscreen-ru-add.po
Patch1: alt-enable-per-screen-scaling.patch
Patch2: alt-improve-output-names.patch
Patch3: alt-fix-widget-display.patch

# Automatically added by buildreq on Mon Mar 02 2015 (-bi)
# optimized out: cmake cmake-modules elfutils libEGL-devel libGL-devel libcloog-isl4 libqt5-core libqt5-dbus libqt5-gui libqt5-network libqt5-printsupport libqt5-qml libqt5-quick libqt5-quickwidgets libqt5-svg libqt5-test libqt5-widgets libqt5-x11extras libqt5-xml libstdc++-devel libxcbutil-keysyms python-base qt5-base-devel ruby ruby-stdlibs
#BuildRequires: extra-cmake-modules gcc-c++ kf5-kauth-devel kf5-kcodecs-devel kf5-kcompletion-devel kf5-kconfig-devel kf5-kconfigwidgets-devel kf5-kcoreaddons-devel kf5-kdbusaddons-devel kf5-kglobalaccel-devel kf5-kguiaddons-devel kf5-ki18n-devel kf5-kiconthemes-devel kf5-kitemviews-devel kf5-kservice-devel kf5-ktextwidgets-devel kf5-kwidgetsaddons-devel kf5-kwindowsystem-devel kf5-kxmlgui-devel kf5-libkscreen-devel kf5-sonnet-devel python-module-google qt5-declarative-devel qt5-x11extras-devel rpm-build-ruby
BuildRequires(pre): rpm-build-kf5
BuildRequires: extra-cmake-modules gcc-c++ qt5-declarative-devel qt5-x11extras-devel qt5-sensors-devel
BuildRequires: libxcbutil-devel
BuildRequires: kf5-kauth-devel kf5-kcodecs-devel kf5-kcompletion-devel kf5-kconfig-devel kf5-kconfigwidgets-devel
BuildRequires: kf5-kcoreaddons-devel kf5-kdbusaddons-devel kf5-kglobalaccel-devel kf5-kguiaddons-devel
BuildRequires: kf5-ki18n-devel kf5-kiconthemes-devel kf5-kitemviews-devel kf5-kservice-devel kf5-ktextwidgets-devel
BuildRequires: kf5-kwidgetsaddons-devel kf5-kwindowsystem-devel kf5-kxmlgui-devel plasma5-libkscreen-devel
BuildRequires: kf5-sonnet-devel kf5-kdeclarative-devel kf5-plasma-framework-devel kf5-kpackage-devel
BuildRequires: kf5-kcmutils-devel
BuildRequires: plasma5-layer-shell-qt-devel

%description
KCM and KDED modules for managing displays in KDE.

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf5-filesystem
Provides: kf5-kscreen-common = %EVR
Obsoletes: kf5-kscreen-common < %EVR
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Provides: kf5-kscreen-devel = %EVR
Obsoletes: kf5-kscreen-devel < %EVR
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.


%prep
%setup -n %rname-%version
#%patch1 -p1
#%patch2 -p1
%patch3 -p1

sed -i 's|^\(add_subdirectory.*tests.*\)|#\1|' CMakeLists.txt

msgcat --use-first po/ru/kcm_kscreen.po %SOURCE10 > po/ru/kcm_kscreen.po.tmp
cat po/ru/kcm_kscreen.po.tmp > po/ru/kcm_kscreen.po
rm -f po/ru/kcm_kscreen.po.tmp
msgcat --use-first po/ru/kscreen.po %SOURCE11 > po/ru/kscreen.po.tmp
cat po/ru/kscreen.po.tmp > po/ru/kscreen.po
rm -f po/ru/kscreen.po.tmp

%build
%K5build

%install
%K5install
%K5install_move data locale kpackage
%find_lang %name --all-name

%files -f %name.lang
%_datadir/qlogging-categories5/*.*categories
%_K5bin/*kscreen*
%_K5plug/plasma/kcms/systemsettings/*kscreen*.so
%_K5plug/kf5/kded/*kscreen*.so
%_K5plug/plasma/applets/*kscreen*.so
%_K5xdgapp/*kscreen*.desktop
%_K5data/kpackage/kcms/kcm_kscreen/
%_kf5_data/plasma/plasmoids/org.kde.kscreen/
%_K5srv/*kscreen*.desktop
%_unitdir_user/*kscreen*.service
%_K5libexecdir/kscreen_osd_service
%_K5dbus_srv/*kscreen*.service
%_datadir/metainfo/*.xml

#%files devel
#%_K5inc/kscreen_version.h
#%_K5inc/KScreen/
#%_K5link/lib*.so
#%_K5lib/cmake/KF5Screen
#%_K5archdata/mkspecs/modules/qt_KScreen.pri

%changelog
