%ifndef _unitdir_user
%define _unitdir_user %prefix/lib/systemd/user
%endif

%define rname kwallet-pam

Name: plasma5-%rname
Version: 5.27.11
Release: alt1
%K5init

Group: Graphical desktop/KDE
Summary: KDE Workspace 5 PAM KWallet integration
Url: http://www.kde.org
License: LGPL-2.1-or-later

Provides: kf5-kwallet-pam = %EVR
Obsoletes: kf5-kwallet-pam < %EVR

Source: %rname-%version.tar
# SuSE
Patch1: 0004-Don-t-call-pam_sm_open_session-within-pam_sm_authent.patch
# ALT
Patch10: alt-allow-empty-password.patch

# Automatically added by buildreq on Thu Aug 27 2015 (-bi)
# optimized out: cmake-modules elfutils libgpg-error libgpg-error-devel libstdc++-devel python-base python3 python3-base ruby ruby-stdlibs
#BuildRequires: cmake gcc-c++ glibc-devel-static libgcrypt-devel libpam-devel rpm-build-python3 rpm-build-ruby
BuildRequires(pre): rpm-build-kf5 rpm-build-ubt
BuildRequires: cmake gcc-c++ glibc-devel extra-cmake-modules qt5-base-devel libgcrypt-devel libpam-devel
BuildRequires: kf5-kwallet-devel
# find kwalletd5
BuildRequires: kf5-kwallet

%package -n pam0_kwallet
Summary: KDE4 PAM KWallet integration
Group: System/Base
Requires: socat
%description -n pam0_kwallet
KDE4 PAM KWallet integration

%package -n pam0_kwallet5
Summary: KDE5 PAM KWallet integration
Group: System/Base
Requires: socat
%description -n pam0_kwallet5
KDE5 PAM KWallet integration

%description
%summary.

%prep
%setup -n %rname-%version
%patch1 -p1
#
%patch10 -p1

%build
KWALLETD_PATH=%_K5bin/kwalletd5
for f in \
    /usr/share/dbus-1/services/org.kde.kwalletd5.service \
    #
do
    [ -e $f ] || continue
    KWALLETD_PATH_NEW=`grep '^Exec=' $f | sed 's|^Exec=||'`
    [ -z "$KWALLETD_PATH_NEW" ] || KWALLETD_PATH=$KWALLETD_PATH_NEW
done
%K5build \
    -DKWALLET5=1 \
    -DCMAKE_INSTALL_LIBDIR=/%_lib \
    -DKWALLETD_BIN_PATH=$KWALLETD_PATH \
    #

%install
%K5install

# fix libs path
if [  -d %buildroot/%_libdir/security ] ; then
    mkdir -p %buildroot/%_lib/security
    mv %buildroot/%_libdir/security/* %buildroot/%_lib/security/
fi

# install pam_kwallet_init
mv \
    %buildroot/%_K5libexecdir/pam_kwallet_init \
    %buildroot/%_K5libexecdir/pam_kwallet5_init

# install pam_kwallet_init.desktop
mv %buildroot/%_K5start/pam_kwallet_init.desktop \
    %buildroot/%_K5start/pam_kwallet5_init.desktop
sed -i '/^Exec=/s|/pam_kwallet_init|/pam_kwallet5_init|' \
    %buildroot/%_K5start/pam_kwallet5_init.desktop

# fix executable path in systemd user service
sed -i '/^ExecStart=/s|/pam_kwallet_init|/pam_kwallet5_init|' \
    %buildroot/%_unitdir_user/plasma-kwallet-pam.service

%files -n pam0_kwallet5
%doc LICENSES/*
%_pam_modules_dir/pam_kwallet5.so
%_K5libexecdir/pam_kwallet5_init
%_K5start/pam_kwallet5_init.desktop
%_unitdir_user/*.service

%changelog
