%define _libexecdir /usr/libexec
%define _scriptdir %_libexecdir/%name

Name: ploop
Version: 7.0.260
Release: alt1
Group: System/Base
License: GPLv2
Summary: Ploop tools
URL: http://wiki.openvz.org/Ploop
Vcs: https://src.openvz.org/scm/ovz/ploop.git
Packager: Viacheslav Dubrovskyi <dubrsl@altlinux.org>

Source: %name-%version.tar
Patch1: %name-%version.patch

ExclusiveArch: x86_64

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev python3-module-setuptools
BuildRequires: libxml2-devel libe2fs-devel libuuid-devel libssl-devel libjson-c-devel
BuildRequires: libdevmapper-devel

%description
This package contains tools to work with ploop devices and images.

%package -n lib%name
Summary: ploop library
Group: System/Libraries
License: LGPLv2.1
Conflicts: vzctl < 4.5
Requires: parted gdisk e2fsprogs lsof

%description -n lib%name
Parallels loopback (ploop) block device API library

%package -n lib%name-devel-static
Summary: Static ploop library
Group: Development/C
License: LGPLv2.1
Requires: lib%name-devel = %EVR

%description -n lib%name-devel-static
Static version of ploop library

%package -n lib%name-devel
Summary: Headers for development with ploop library
Group: Development/C
License: GPLv2 or LGPLv2.1
Requires: lib%name = %EVR

%description -n lib%name-devel
Headers of ploop library

%package -n python3-module-%name
Summary: Python bindings for %name
Group: Development/Python
Requires: lib%name = %EVR
Provides: python3(libploopapi)

%description -n python3-module-%name
python3-module-%name contains Python bindings for %name.

%prep
%setup -q
%patch1 -p1

%build
export PYTHON=%__python3
%make_build LIBDIR=%_libdir PLOOP_LOG_FILE=%_logdir/%name.log DEBUG=no all

%install
export PYTHON=%__python3
mkdir -p %buildroot%_sbindir
make \
    DESTDIR=%buildroot \
    LIBDIR=%_libdir \
    PLOOP_LOG_FILE=%_logdir/%name.log \
    TMPFILESDIR=%_tmpfilesdir \
    MODULESLOADDIR=%_modulesloaddir \
    install

%files
/sbin/*
%_sbindir/*
%_man8dir/*
%_logrotatedir/%name
%_modulesloaddir/%name.conf
%_sysconfdir/bash_completion.d/

%files -n lib%name
%_libdir/lib%name.so.*
%_lockdir/%name
%_tmpfilesdir/*
%dir %_scriptdir
%_scriptdir/*
%dir %_scriptdir-test
%_scriptdir-test/*

%files -n lib%name-devel-static
%_libdir/libploop.a

%files -n lib%name-devel
%_libdir/lib%name.so
%_includedir/%name
%_pkgconfigdir/%name.pc

%files -n python3-module-%name
%python3_sitelibdir/*

%changelog
