%define origname PonyProg2000

Name: ponyprog2000
Version: 2.07c
Release: alt4
Summary: Serial device programmer
# http://downloads.sourceforge.net/ponyprog/%origname-%version.tar.gz
Source: %origname-%version.tar.bz2
Source1: %name.png
License: GPL
Group: Development/Other
Url: http://www.lancos.com/prog.html
Packager: Evgeny Sinelnikov <sin@altlinux.ru>

Patch: PonyProg2000.patch

# Automatically added by buildreq on Thu Oct 25 2007
BuildRequires: gcc-c++ libXaw-devel

BuildRequires: libv-devel >= 1.90-alt4
BuildRequires: ImageMagick, linux-libc-headers
BuildRequires: libXext-devel

Requires: libv >= 1.90-alt4

%description
PonyProg is a serial device programmer software with a user friendly GUI
framework available for Windows95, 98, 2000 & NT and Intel Linux. Its purpose
is reading and writing every serial device. At the moment it supports I2C Bus,
Microwire, SPI eeprom, the Atmel AVR and Microchip PIC micro.

%prep
%setup -n %origname-%version
%patch -p1

%build
make

%install
mkdir -p %buildroot%_bindir
cp bin/ponyprog2000 %buildroot%_bindir

mkdir -p %buildroot%_niconsdir
mkdir -p %buildroot%_miconsdir
mkdir -p %buildroot%_liconsdir

convert -resize 16x16 %SOURCE1 %buildroot%_miconsdir/%name.png
convert -resize 32x32 %SOURCE1 %buildroot%_niconsdir/%name.png
convert -resize 48x48 %SOURCE1 %buildroot%_liconsdir/%name.png

mkdir -p %buildroot%_desktopdir
cat > %buildroot%_desktopdir/%name.desktop << EOF
[Desktop Entry]
Name=Ponyprog2000
Comment=Serial device programmer
Exec=%_bindir/%name
Icon=%name
Terminal=false
Type=Application
Categories=Development;Engineering;Electronics;
EOF

%files
%doc README
%_bindir/%name
%_miconsdir/%name.png
%_liconsdir/%name.png
%_niconsdir/%name.png
%_desktopdir/*

%changelog
