%define _unpackaged_files_terminate_build 1
%define pg_ver 15

Name: postgresql%pg_ver-postgis
Version: 3.5.2
Release: alt1

Summary: Geographic Information Systems Extensions to PostgreSQL %pg_ver
Summary(ru_RU.UTF-8): Геоинформационные расширения для PostgreSQL %pg_ver
License: GPL-2.0
Group: Databases
Url: http://postgis.refractions.net

Source: postgis-%version.tar.gz
Source1: create_template_postgis
Source2: postgis.watch

BuildRequires: gcc-c++
BuildRequires: ImageMagick-tools
BuildRequires: docbook-dtds
BuildRequires: docbook5-style-xsl
BuildRequires: flex
BuildRequires: libgdal-devel
BuildRequires: libgeos-devel
BuildRequires: libgtk+2-devel
BuildRequires: libproj-devel
BuildRequires: libxml2-devel
BuildRequires: postgresql%pg_ver-server-devel
BuildRequires: libjson-c-devel
BuildRequires: libprotobuf-c-devel
BuildRequires: protobuf-c-compiler
BuildRequires: libpcre-devel
BuildRequires: xsltproc

Requires: postgresql%pg_ver-server
Provides: postgis

%description
PostGIS adds support for geographic objects to the PostgreSQL
object-relational database. In effect, PostGIS "spatially enables" the
PostgreSQL server, allowing it to be used as a backend spatial
database for geographic information systems (GIS).

%description -l ru_RU.UTF-8
PostGIS добавляет поддержку географических объектов в PostgreSQL. В
сущности PostGIS является расширением PostgreSQL сервера,
позволяющим использовать его для хранения и обработки геоданных в
геоинформационных системах (ГИС).

%prep
%setup -n postgis-%version
subst "s|PGSQL_DOCDIR|DOCDIR|g" doc/Makefile.in

%build
export PCRE_CPPFLAGS=-I/usr/include/pcre
./autogen.sh
subst 's/PGSQL_FULL_VERSION=.*/PGSQL_FULL_VERSION="PostgreSQL %pg_ver.0"/' configure
%configure \
	--disable-static \
	--with-gui \
	--with-raster \
	--with-xsldir="$(ls -d %_datadir/usr/share/sgml/docbook/xsl-ns-stylesheets-*)"
%make all docs comments

%install
install -pD -m0755 %SOURCE1 %buildroot%_bindir/create_template_postgis
install -d %buildroot%_libdir/pgsql/
install -d %buildroot%_includedir
%makeinstall_std
%makeinstall_std -C doc docs-install comments-install man-install DOCDIR=%_docdir/postgis-%version

rm -rf %buildroot%_libdir/liblwgeom.a

%files
%doc %_docdir/postgis
%doc %_docdir/postgis-%version
%doc %_datadir/doc/postgresql/extension/README.address_standardizer
%_bindir/*
%_man1dir/*
%_datadir/applications/shp2pgsql-gui.desktop
%_datadir/icons/hicolor/*/apps/shp2pgsql-gui.png
%_bindir/create_template_postgis
%_libdir/pgsql/postgis*.so
%ifnarch %e2k loongarch64
%_libdir/pgsql/bitcode
%endif
%_libdir/pgsql/address_standardizer*.so
%_datadir/pgsql/contrib/postgis-*/*.sql
%_datadir/pgsql/extension

%changelog
