Name: powdertoy
Version: 96.0.348
Release: alt1
Summary: Classic 'falling sand' physics sandbox game
Group: Games/Educational
Epoch: 1
License: GPLv3
Url: http://powdertoy.co.uk/
# GitHub https://github.com/FacialTurd/The-Powder-Toy/tags
Source: v%version.tar.gz
Obsoletes: powder

# Automatically added by buildreq on Fri Jul 02 2021
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 libX11-devel libcrypt-devel libglvnd-devel liblua5.1-devel libp11-kit libreadline-devel libsasl2-3 libstdc++-devel libxcb-devel ninja-build perl pkg-config python3 python3-base sh4 xz
BuildRequires: bzlib-devel cmake ctags gcc-c++ git-core libSDL2-devel libcurl-devel libfftw3-devel libluajit-devel meson zlib-devel

%description
The Powder Toy is a desktop version of the classic 'falling sand'
physics sandbox game, it simulates air pressure and velocity as well as
heat!

%prep
%setup -n The-Powder-Toy-%version
# Hack out version update messge
sed -i 's/gameModel->AddNotification.*\("A new.*available.*update"\).*;/fprintf(stderr, "%%s\\n", \1);/g' src/gui/game/GameController.cpp

cat > %name.sh <<@@@
#!/bin/sh
test -d "\$HOME/.powdertoy" ||
{ rm -f "\$HOME/.powdertoy"; mkdir -p "\$HOME/.powdertoy/Brushes"; }
cd "\$HOME/.powdertoy" && \$0.bin
@@@

cat > %name.desktop <<@@@
[Desktop Entry]
Name=The Powder Toy
Type=Application
Exec=%name
Icon=%name
Terminal=false
GenericName=Sandbox game
Categories=Game;Simulation;
Comment=%summary
@@@

%build
%meson
%meson_build

%install
# TODO MIME (it can install mime locally!)
install -D %_cmake__builddir/powder %buildroot%_gamesbindir/%name.bin
install -m755 %name.sh %buildroot%_gamesbindir/%name
install -D %name.desktop %buildroot%_desktopdir/%name.desktop
for N in resources/icon/new-unused/icon_*.png ; do
	install -D $N %buildroot%_iconsdir/hicolor/$(basename ${$##*_} .png)/apps/%name.png
done

%files
%doc *.txt *.md
%_gamesbindir/*
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/apps/*

%changelog
