%def_enable snapshot

%define rdn_name io.github.pragha-music-player

%def_disable libxfce4ui
%def_enable grilo
# works only with rygel-2.2
%def_disable rygel

Name: pragha
Version: 1.3.99.1
Release: alt2

Summary: Pragha is a "Fork" of consonance Music manager
License: GPLv3
Group: Sound
Url: http://pragha-music-player.github.io/

%if_disabled snapshot
Source: https://github.com/%name-music-player/%name/releases/download/v%version/%name-%version.tar.bz2
%else
# VCS: https://github.com/pragha-music-player/pragha.git
Source: %name-%version.tar
%endif
# adapt to newer keybinder
Patch: pragha-1.3.3-alt-configure.patch

%define gtk_ver 3.14

Requires: gst-plugins-base1.0
Requires: gst-plugins-good1.0

BuildRequires: libcddb-devel libcdio-devel libcdio-paranoia-devel
BuildRequires: libclastfm-devel libglyr-devel
BuildRequires: libkeybinder-devel libnotify-devel libtag-devel
BuildRequires: gstreamer1.0-devel gst-plugins1.0-devel libgtk+3-devel >= %gtk_ver
BuildRequires: libpeas-devel libtotem-pl-parser-devel
BuildPreReq: libgudev-devel libsoup-devel libjson-glib-devel libmtp-devel
%{?_enable_rygel:BuildRequires: rygel-devel}
%{?_enable_grilo:BuildRequires: libgrilo-devel}
%{?_enable_libxfce4ui:BuildRequires: libxfce4ui-devel}
# requires for autogen.sh
BuildRequires: xfce4-dev-tools

%description
Pragha is a reproducer and administrator of music for GNU/Linux, based
on Gtk, sqlite, and completely written in C, constructed to be fast,
light, and simultaneously complete without obstructing the daily work.

%prep
%setup
%patch
subst 's/%name.appdata/%rdn_name.metainfo/' data/Makefile.am

%build
%add_optflags %(getconf LFS_CFLAGS)
NOCONFIGURE=1 xdt-autogen
%configure \
	%{subst_enable libxfce4ui} \
	LIBS="%(pkg-config taglib_c --libs) %(pkg-config gio-2.0 --libs)"
%make_build V=1

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang

%_bindir/*
%_libdir/%name/
%_datadir/%name/
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/*/pragha*
%_man1dir/%name.1.*
%_pixmapsdir/%name
%_datadir/metainfo/*
%doc ChangeLog FAQ NEWS README

#devel
%exclude %_includedir/lib%name
%exclude %_pkgconfigdir/lib%name.pc

%changelog
