%define _unpackaged_files_terminate_build 1

Name: pspp
Version: 1.6.2
Release: alt1.1

Summary: A program for statistical analysis of sampled data.
License: GPLv3+
Group: Sciences/Mathematics

Url: http://www.gnu.org/software/pspp/

Source: %name-%version.tar.zst

BuildRequires: libgsl-devel
BuildRequires: perl-devel perl-Text-Diff
BuildRequires: python3
BuildRequires: iconv
BuildRequires: zlib
BuildRequires: libxml2-devel
BuildRequires: libcairo-devel
BuildRequires: libpango-devel
#to enable PSPPIRE
BuildRequires: libgtk+3
BuildRequires: libgtksourceview4-devel
BuildRequires: libspread-sheet-widget-devel
#Optional according to INSTALL file
BuildRequires: libreadline-devel
BuildRequires: texinfo
BuildRequires: fonts-ttf-liberation
BuildRequires: texlive-dist

%description
GNU PSPP is a program for statistical analysis of sampled data. It is a free as
in freedom replacement for the proprietary program SPSS, and appears very
similar to it with a few exceptions.

%prep
%setup 

%build
%ifarch i586 armh
%configure --disable-static --disable-rpath --disable-year2038
%else
%configure --disable-static --disable-rpath
%endif
%make_build

%install
%makeinstall_std
%makeinstall_std install-html
%makeinstall_std install-pdf

rm -rf %buildroot%_infodir/screenshots
rm -rf %buildroot%_infodir/pspp-figures

%find_lang --output=%name.lang %name

%check
%make_build check

%files -f %name.lang
%doc NEWS ONEWS COPYING THANKS AUTHORS README
%doc %_datadir/doc/%name
%_bindir/pspp
%_bindir/pspp-convert
%_bindir/pspp-dump-sav
%_bindir/pspp-output
%_bindir/psppire
%_libdir/%name/
%exclude %_libdir/%name/*.la
%_iconsdir/hicolor/*/mimetypes/application-x-spss-*.png
%_iconsdir/hicolor/*/apps/org.gnu.pspp.*
%_desktopdir/org.gnu.pspp.desktop
%_datadir/metainfo/org.gnu.pspp.metainfo.xml
%_datadir/mime/packages/org.gnu.pspp.xml
%_infodir/pspp*
%_man1dir/*
%_datadir/%name/

%changelog
