%define _unpackaged_files_terminate_build 1

Name: pve-storage
Summary: PVE storage management library
Version: 7.4.3
Release: alt1
License: AGPL-3.0+
Group: Development/Perl
Url: https://git.proxmox.com/

ExclusiveArch: x86_64 aarch64

Provides: libpve-storage-perl = %EVR
Requires: gdisk parted hdparm
Requires: multipath-tools lvm2 thin-provisioning-tools
Requires: ceph >= 12.2.1 ceph-fuse
Requires: cifs-utils samba-client
Requires: cstream
Requires: glusterfs-client >= 3.4.2
Requires: zfs-utils
Requires: nfs-clients nfs-utils
Requires: /usr/bin/iscsi-ls open-iscsi
Requires: proxmox-backup-client >= 1.0 proxmox-backup-file-restore
Requires: smartmontools

Source: %name-%version.tar
Patch: %name-%version.patch

BuildRequires: librados2-perl pve-common pve-cluster >= 5.0.32 libpve-cluster-perl
BuildRequires: pve-doc-generator >= 5.3.3 pve-access-control pve-apiclient xmlto
BuildRequires: perl(File/chdir.pm) perl(Net/DBus.pm) perl(POSIX/strptime.pm)
BuildRequires: perl(PVE/DataCenterConfig.pm)

%description
This package contains the storage management library used by PVE

%prep
%setup
%patch -p1

%install
%makeinstall_std

mkdir -p %buildroot%_sysconfdir/modules-load.d
cat << __EOF__ > %buildroot%_sysconfdir/modules-load.d/pve-storage.conf
rbd
__EOF__

%files
%doc debian/copyright
%config(noreplace) %_sysconfdir/modules-load.d/pve-storage.conf
%_sbindir/pvesm
%_udevrulesdir/*.rules
%_prefix/libexec/ceph-rbdnamer-pve
%perl_vendor_privlib/PVE
%_datadir/bash-completion/completions/*
%_datadir/zsh/vendor-completions/*
%_man1dir/pvesm.1*

%changelog
