%define _unpackaged_files_terminate_build 1

Name: py
Version: 1.9.0
Release: alt2

Summary: Testing and distributed programming library
License: MIT
Group: Development/Tools
# Source-git: https://github.com/pytest-dev/py.git
Url: https://github.com/pytest-dev/py

Source: %name-%version.tar
Source2: move.list
Patch: %name-%version-alt.patch

BuildRequires: python2.7(setuptools_scm)
BuildRequires: python2.7(apipkg)

BuildArch: noarch
Requires: python-module-%name = %EVR

%define move_list %(echo `cat %SOURCE2`)

%description
The py lib has several namespaces which help with testing, generating
and distributing code across machines.

%package -n python-module-%name
Summary: Python module of testing and distributed programming library
Group: Development/Python
Conflicts: %name
%py_provides %move_list
%py_requires apipkg
%py_requires iniconfig

%description -n python-module-%name
The py lib has several namespaces which help with testing, generating
and distributing code across machines.

This package contains python module of %name lib.

%prep
%setup
%patch0 -p1

# remove bundled packages
rm -r py/_vendored_packages

%build
# SETUPTOOLS_SCM_PRETEND_VERSION: when defined and not empty,
# its used as the primary source for the version number in which
# case it will be a unparsed string
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python_install

# check the actual provides against predefined ones
set -o pipefail
PYTHONPATH="$(pwd)" python2 -c \
"from __future__ import print_function; import py, apipkg;\
assert py.__version__==\"%version\";\
modules=[ 'py.' + mod for mod in dir(py) if isinstance(getattr(py, mod), apipkg.ApiModule) ];\
print(*modules, sep='\n')" | sort > move.actual.list
set +o pipefail
cat %SOURCE2 | sort > move.expected.list
diff -y move.expected.list move.actual.list

%check

%files -n python-module-%name
%doc AUTHORS CHANGELOG LICENSE *.rst
%python_sitelibdir/py/
%python_sitelibdir/py-*.egg-info/

%changelog
