%define oname py2pack

Name:       py2pack
Version:    0.8.7
Release:    alt1

Summary:    Generate distribution packages from Python packages on PyPI
License:    GPL-2.0+
Group:      Development/Python3
Url:        http://github.com/saschpe/py2pack
Packager:   Andrey Cherepanov <cas@altlinux.org>

BuildArch:  noarch

Source:     %name-%version.tar
Patch1:     py2pack-alt-spec-support.patch
Patch2:     py2pack-alt-spec-default.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-jinja2 python3-module-six
BuildRequires: python3-module-cssselect python3-module-lxml
BuildRequires: python3-module-requests
BuildRequires: python3-module-pbr

Requires: python3-module-py2pack = %version-%release

%description
This script allows to generate RPM spec or DEB dsc files from Python modules.
It allows to list Python modules or search for them on the Python Package Index
(PyPI). Conveniently, it can fetch tarballs and change logs making it an
universal tool to package Python modules.

%package -n python3-module-py2pack
Summary: General purpose template engine
Group: Development/Python3
%py3_requires pbr

%description -n python3-module-py2pack
This script allows to generate RPM spec or DEB dsc files from Python modules.
It allows to list Python modules or search for them on the Python Package Index
(PyPI). Conveniently, it can fetch tarballs and change logs making it an
universal tool to package Python modules.

%prep
%setup -n %oname-%version
%patch1 -p1
%patch2 -p1

%build
export PBR_VERSION=%version
%python3_build

%install
export PBR_VERSION=%version
%python3_install

%files
%_bindir/%oname

%files -n python3-module-py2pack
%python3_sitelibdir/%{oname}*

%changelog
