%define oname gevent

%def_without python3
%def_disable embed

Name: python-module-%oname
Version: 1.4.0
Release: alt4

Summary: Python network library that uses greenlet and libevent for easy and scalable concurrency

Group: Development/Python
License: MIT
Url: http://pypi.python.org/pypi/gevent

%add_findreq_skiplist %python_sitelibdir/gevent/_socket3.py
%add_python_req_skip test

# https://github.com/surfly/gevent.git
Source: %oname-%version.tar

BuildRequires(pre): rpm-macros-sphinx
#BuildRequires: python-module-repoze.sphinx.autointerface
BuildRequires: libev-devel libcares-devel
BuildRequires: python-module-Cython python-module-alabaster python-module-html5lib python-module-objects.inv
BuildRequires: python-module-greenlet

%setup_python_module %oname
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-repoze.sphinx.autointerface
BuildRequires: python3-module-greenlet
BuildRequires: python3-module-OpenSSL
BuildRequires: python3-module-Cython python3-module-cryptography python3-module-html5lib
%endif

%py_requires greenlet

%description
gevent is a coroutine-based Python networking library that uses greenlet
to provide a high-level synchronous API on top of libevent event loop.

Features include:
* convenient API around greenlets
* familiar synchronization primitives (gevent.event, gevent.queue)
* socket module that cooperates
* WSGI server on top of libevent-http
* DNS requests done through libevent-dns
* monkey patching utility to get pure Python modules to cooperate

%package -n python-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description -n python-module-%oname-tests
This package contains tests for %oname.

%package -n python-module-greentest
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR
Requires: %name-tests = %EVR

%description -n python-module-greentest
gevent is a coroutine-based Python networking library that uses greenlet
to provide a high-level synchronous API on top of libevent event loop.

This package contains tests for %oname.

%if_with python3
%package -n python3-module-%oname
Summary: Python 3 network library that uses greenlet and libevent for easy and scalable concurrency
Group: Development/Python3
%py3_requires greenlet
%add_python3_req_skip gevent.libev._corecffi

%description -n python3-module-%oname
gevent is a coroutine-based Python networking library that uses greenlet
to provide a high-level synchronous API on top of libevent event loop.

Features include:
* convenient API around greenlets
* familiar synchronization primitives (gevent.event, gevent.queue)
* socket module that cooperates
* WSGI server on top of libevent-http
* DNS requests done through libevent-dns
* monkey patching utility to get pure Python modules to cooperate

%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
This package contains tests for %oname.

%package -n python3-module-greentest
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR
Requires: python3-module-%oname-tests = %EVR

%description -n python3-module-greentest
gevent is a coroutine-based Python networking library that uses greenlet
to provide a high-level synchronous API on top of libevent event loop.

This package contains tests for %oname.
%endif

%package doc
Summary: Documentation for gevent
Group: Development/Documentation
BuildArch: noarch

%description doc
gevent is a coroutine-based Python networking library that uses greenlet
to provide a high-level synchronous API on top of libevent event loop.

This package contains documentation and examples for gevent.

%package pickles
Summary: Pickles for gevent
Group: Development/Documentation

%description pickles
gevent is a coroutine-based Python networking library that uses greenlet
to provide a high-level synchronous API on top of libevent event loop.

This package contains pickles for gevent.

%prep
%setup

%if_disabled embed
rm -rf deps
%endif

%if_with python3
cp -a . ../python3
%endif

%prepare_sphinx doc

%build
%add_optflags -fno-strict-aliasing
%if_disabled embed
export GEVENT_NO_CFFI_BUILD=1
export LIBEV_EMBED=0
export CARES_EMBED=0
%endif

# remove all versions of greentest, leave only versions for current python version
pushd src/greentest
for i in * ; do
	if [ -z "$(echo $i | grep ^%__python_version$)" ] ; then
 		rm -fR $i
	fi
done
popd
%python_build_debug

%if_with python3
pushd ../python3
export CYTHON=cython3
rm -fR src/gevent/_util_py2.py*
# remove all versions of greentest, leave only versions for current python3 version
pushd src/greentest
for i in * ; do
	if [ -z "$(echo $i | grep ^%__python3_version$)" ] ; then
		rm -fR $i
	fi
done
popd
%python3_build_debug
popd
%endif

%install
%if_disabled embed
export GEVENT_NO_CFFI_BUILD=1
export LIBEV_EMBED=0
export CARES_EMBED=0
%endif

%python_install
cp -fR src/greentest %buildroot%python_sitelibdir/

%if_with python3
pushd ../python3
%python3_install
cp -fR src/greentest %buildroot%python3_sitelibdir/
popd
%endif

#doc

export PYTHONPATH=%buildroot%python_sitelibdir
pushd doc
#make pickle
#make html

#cp -fR _build/pickle %buildroot%python_sitelibdir/%oname/
popd

%files
%doc AUTHORS LICENSE* TODO *.rst
%python_sitelibdir/*
#exclude %python_sitelibdir/%oname/pickle
%exclude %python_sitelibdir/greentest
%exclude %python_sitelibdir/%oname/tests
%exclude %python_sitelibdir/%oname/testing

%files -n python-module-%oname-tests
%python_sitelibdir/%oname/tests/
%python_sitelibdir/%oname/testing/

%files -n python-module-greentest
%python_sitelibdir/greentest

#files doc
#doc doc/_build/html
#doc examples

#files pickles
#python_sitelibdir/%oname/pickle

%if_with python3
%files -n python3-module-%oname
%doc AUTHORS LICENSE* TODO *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/greentest
%exclude %python3_sitelibdir/%oname/tests
%exclude %python3_sitelibdir/%oname/testing

%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/tests/
%python3_sitelibdir/%oname/testing/

%files -n python3-module-greentest
%python3_sitelibdir/greentest
%endif

%changelog
