%define _unpackaged_files_terminate_build 1

%define oname greenlet

Name: python-module-%oname
Version: 0.4.15
Release: alt2

Summary: Lightweight in-process concurrent programming
License: MIT
Group: Development/Python
Url: http://pypi.python.org/pypi/greenlet

# https://github.com/python-greenlet/greenlet.git
Source0: https://pypi.python.org/packages/03/a6/8842d7215e1c54537eb5d0b8fd3e8562cc869b6d193317b11027ff7d8009/%{oname}-%{version}.tar.gz

BuildRequires(pre): rpm-build-python
BuildRequires: gcc-c++


%description
The greenlet package is a spin-off of Stackless, a version of CPython
that supports micro-threads called "tasklets". Tasklets run
pseudo-concurrently (typically in a single or a few OS-level threads)
and are synchronized with data exchanges on "channels".

A "greenlet", on the other hand, is a still more primitive notion of
micro- thread with no implicit scheduling; coroutines, in other words.
This is useful when you want to control exactly when your code runs. You
can build custom scheduled micro-threads on top of greenlet; however, it
seems that greenlets are useful on their own as a way to make advanced
control flow structures. For example, we can recreate generators; the
difference with Python's own generators is that our generators can call
nested functions and the nested functions can yield values too.
Additionally, you don't need a "yield" keyword. See the example in
tests/test_generator.py.

Greenlets are provided as a C extension module for the regular
unmodified interpreter.

%package tests
Summary: Tests for greenlet
Group: Development/Python
BuildArch: noarch
Requires: %name = %version-%release

%description tests
The greenlet package is a spin-off of Stackless, a version of CPython
that supports micro-threads called "tasklets". Tasklets run
pseudo-concurrently (typically in a single or a few OS-level threads)
and are synchronized with data exchanges on "channels".

This package contains tests for greenlet.

%prep
%setup -q -n %{oname}-%{version}

%build
%python_build_debug

%install
%python_install

%check
%__python setup.py test -v
export PYTHONPATH=$PWD
%__python run-tests.py -n

%files
%doc AUTHORS LICENSE NEWS README* doc/*.txt
%python_sitelibdir/*
%_includedir/python%_python_version/greenlet

%files tests
%doc tests


%changelog
