%define _unpackaged_files_terminate_build 1
%define mname ldap

Name: python-module-%mname
Version: 3.2.0
Release: alt3

Summary: An object-oriented API to access LDAP directory servers from Python programs
License: Python-style
Group: Development/Python
Url: https://www.python-ldap.org
# Source-git: https://github.com/python-ldap/python-ldap

Source: %name-%version.tar

BuildRequires: libldap-devel
BuildRequires: libsasl2-devel
BuildRequires: libssl-devel

Provides: python-module-pyldap = %EVR
Obsoletes: python-module-pyldap < %EVR

%description
python-ldap provides an object-oriented API to access LDAP
directory servers from Python programs. Mainly it wraps the
OpenLDAP client libs for that purpose.

Additionally the package contains modules for other LDAP-related
stuff (e.g. processing LDIF, LDAPURLs, LDAPv3 sub-schema, etc.).

%prep
%setup

# Fix python interpreter path in Demo directory
grep -rl '^#!/usr/bin/env python' ./ | \
	xargs sed -i '1s|^#!/usr/bin/env python|#!/usr/bin/python2|'

%build
%add_optflags -fno-strict-aliasing
%python_build_debug

%install
%python_install

%files
%doc LICENCE CHANGES README TODO Demo
%exclude %python_sitelibdir/slapdtest
%python_sitelibdir/_ldap.so
%python_sitelibdir/ldap
%python_sitelibdir/ldapurl.py*
%python_sitelibdir/ldif.py*
%python_sitelibdir/python_ldap-%{version}*-*.egg-info

%changelog
