%define _unpackaged_files_terminate_build 1
%define oname pathlib

Name: python-module-%oname
Version: 1.0.1
Release: alt3
Summary: Object-oriented filesystem paths
License: MIT
Group: Development/Python
Url: https://pypi.python.org/pypi/pathlib/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar
BuildArch: noarch

BuildRequires: python-test
BuildRequires: python-module-pytest

%description
pathlib offers a set of classes to handle filesystem paths. It offers
the following advantages over using string objects:

* No more cumbersome use of os and os.path functions. Everything can be
  done easily through operators, attribute accesses, and method calls.
* Embodies the semantics of different path types. For example, comparing
  Windows paths ignores casing.
* Well-defined semantics, eliminating any warts or ambiguities (forward
  vs. backward slashes, etc.).

%prep
%setup

%build
%python_build

%install
%python_install

%check
py.test -v

%files
%doc *.txt docs/*.rst
%python_sitelibdir/pathlib.py*
%python_sitelibdir/pathlib-*.egg-info/

%changelog
