%define _unpackaged_files_terminate_build 1
%define oname pluggy

%def_without check

Name: python-module-%oname
Version: 0.13.0
Release: alt3

Summary: Plugin and hook calling mechanisms for python
License: MIT
Group: Development/Python
# Source-git: https://github.com/pytest-dev/pluggy.git
Url: https://pypi.python.org/pypi/pluggy

BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python
BuildRequires: python2.7(setuptools_scm)

%py_requires importlib_metadata

%if_with check
BuildRequires: python2.7(importlib_metadata)
BuildRequires: python2.7(pytest)
BuildRequires: python2.7(tox)
%endif


%description
This is the plugin manager as used by pytest but stripped of pytest
specific details.

%prep
%setup

# there is a file with name CHANGELOG.rst, not CHANGELOG
# a wrong reference leads to broken install via pip
sed -i '/^include CHANGELOG$/{s/$/.rst/}' MANIFEST.in

%build
# SETUPTOOLS_SCM_PRETEND_VERSION: when defined and not empty,
# its used as the primary source for the version number in which
# case it will be a unparsed string
export SETUPTOOLS_SCM_PRETEND_VERSION=%version

%python_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python_install

%check
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python}
sed -i -e '/^\[testenv\]$/a whitelist_externals =\
    \/bin\/cp\
    \/bin\/sed\
commands_pre =\
    \/bin\/cp {env:_PYTEST_BIN:} \{envbindir\}\/pytest\
    \/bin\/sed -i \x271c #!\{envpython\}\x27 \{envbindir\}\/pytest' \
-e '/^setenv[ ]*=/a\
    py%{python_version_nodots python}: _PYTEST_BIN=%_bindir\/py.test' \
tox.ini
tox --sitepackages -p auto -o -v -r


%files
%doc LICENSE CHANGELOG.rst README.rst
%python_sitelibdir/pluggy/
%python_sitelibdir/pluggy-*.egg-info/


%changelog
