%define _name pyatspi
%define ver_major 2.38

%def_enable tests
%def_disable check

Name: python-module-%_name
Version: %ver_major.0
Release: alt1

Summary: Python bindings for at-spi library
Group: Development/Python
License: LGPL-2.0
Url: http://www.linuxfoundation.org/en/AT-SPI_on_D-Bus

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

BuildArch: noarch

%define pygobject_ver 3.9.90

BuildRequires(pre): rpm-build-python rpm-build-gir
BuildRequires: python-devel python-module-pygobject3-devel >= %pygobject_ver
BuildRequires: libX11-devel libICE-devel libSM-devel
%{?_enable_tests:BuildRequires: python-module-dbus-gobject python-module-dbus-devel
BuildRequires: libat-spi2-core-devel libgtk+3-devel libxml2-devel}
%{?_enable_check:BuildRequires: /proc dbus typelib(Atspi) = 2.0 typelib(Gtk) = 3.0}

%description
at-spi allows assistive technologies to access GTK-based
applications. Essentially it exposes the internals of applications for
automation, so tools such as screen readers, magnifiers, or even
scripting interfaces can query and interact with GUI controls.

This version of at-spi is a major break from previous versions.
It has been completely rewritten to use D-Bus rather than
ORBIT / CORBA for its transport protocol.

This package includes a python client library for at-spi.

%prep
%setup -n %_name-%version

%build
export PYTHON=%__python
%autoreconf
%configure --with-python=%__python \
	%{subst_enable tests}
%nil
%make_build

%install
%makeinstall_std

%check
%make check

%files
%python_sitelibdir/%_name/
%doc AUTHORS README NEWS


%changelog
